package com.smartgwt.sample.showcase.client.portal;

import java.util.HashMap;
import java.util.Map;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.EntryPoint;
import com.smartgwt.client.tools.CSSEditor;
import com.smartgwt.client.tools.StyleGroup;
import com.smartgwt.client.tools.StyleSetting;
import com.smartgwt.client.util.JSONEncoder;
import com.smartgwt.client.util.JSOHelper;
import com.smartgwt.client.util.StringUtil;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.tools.events.EditCompleteEvent;
import com.smartgwt.client.widgets.tools.events.EditCompleteHandler;
import com.smartgwt.client.widgets.tools.events.ValuesChangedEvent;
import com.smartgwt.client.widgets.tools.events.ValuesChangedHandler;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.HTMLFlow;
import com.smartgwt.sample.showcase.client.AdvancedPanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class StyleEditorSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "<p>A component for editing styles and producing CSS settings or text.</p>";

    public static class Factory extends AdvancedPanelFactory {
        @Override
        public String getDescription() {
            return DESCRIPTION;
        }

        @Override
        public HTMLFlow getDisabledViewPanel() {
            final HTMLFlow htmlFlow = new HTMLFlow(
                "<div class='explorerCheckErrorMessage'><p>This example is disabled because it requires the optional " +
                "<a href=\"http://www.smartclient.com/product/index.jsp\" target=\"_blank\">Dashboard &amp; Tools module</a>.</p>" +
                "<p>Click <a href=\"http://www.smartclient.com/smartgwtee/showcase/#portalLayout\" target=\"\">here</a> " +
                "to see this example on SmartClient.com.</p></div>"
            );
            htmlFlow.setWidth100();
            return htmlFlow;
        }

        @Override
        public boolean isEnabled() {
            return SC.hasDashboardAndTools();
        }

        @Override
        public ShowcasePanel createShowcasePanel() {
            return new StyleEditorSample();
        }
    }

    public Canvas getViewPanel() {
	    Map<String,String> values = new HashMap<String,String>();
    	values.put("border", "1px solid red");
    	values.put("border-radius", "5px");
    	values.put("padding", "3px");
    	
    	StyleGroup styleGroup = new StyleGroup();
    	styleGroup.setName("myGroup");
    	styleGroup.setTitle("Border / Radius / Padding");
    	styleGroup.setCanCollapse(false);
    	styleGroup.setAllowAsymmetry(true);
    	
    	StyleSetting setting = new StyleSetting();
    	setting.setName("border");
    	StyleSetting setting1 = new StyleSetting();
    	setting1.setName("border-radius");
    	StyleSetting setting2 = new StyleSetting();
    	setting2.setName("padding");
    	
    	styleGroup.setSettings(setting,setting1,setting2);
    	
    	final Label label = new Label();
        label.setHeight(10);
    	
    	final CSSEditor ed = new CSSEditor();
    	ed.setGroups(styleGroup);
        ed.setWidth(450);
    	ed.addEditCompleteHandler(new EditCompleteHandler() {
			@Override
			public void onEditComplete(EditCompleteEvent event) {
				String css = ed.getCSSText().replaceAll(";", ";\n");
				
                JavaScriptObject jso = JSOHelper.convertMapToJavascriptObject(ed.getCSSProperties());
                String settings = StringUtil.asHTML(new JSONEncoder().encode(jso));
				
		        String msg = "<pre>== CSS text ==\n" + css + "\n\n== Settings ==<br>" + settings + "</pre>";
		        SC.say(msg);
			}
    	});
    	
    	ed.addValuesChangedHandler(new ValuesChangedHandler() {
			@Override
			public void onValuesChanged(ValuesChangedEvent event) {
				// log the new output, both CSS-text and block of CSS-properties
				String css = ed.getCSSText().replaceAll(";", ";\n");
				
                JavaScriptObject jso = JSOHelper.convertMapToJavascriptObject(ed.getCSSProperties());
                String settings = StringUtil.asHTML(new JSONEncoder().encode(jso));
				
		        String msg = "<pre>== CSS text ==\n" + css + "\n\n== Settings ==<br>" + settings + "</pre>";
		        label.setContents(msg);
			}
    	});
    	
    	HLayout hLayout = new HLayout();
    	hLayout.setMembersMargin(10);
    	hLayout.addMember(ed);
    	hLayout.addMember(label);
		ed.setValues(values);
		return hLayout;
    }

    public String getIntro() {
        return DESCRIPTION;
	}

}
