package com.smartgwt.sample.showcase.client.grid.filtering;

import com.google.gwt.user.client.Timer;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.DSOperationType;
import com.smartgwt.client.data.ResponseTransformer;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class MixedFilteringSample extends ShowcasePanel {

    private static final String DESCRIPTION = "Client-side filtering in SmartGWT is incredibly powerful and "+
        "is a key reason that "+
        "SmartGWT applications are so very fast - so many operations that would have required a "+
        "server trip in other technologies are handled right in the browser in a SmartGWT application! "+
        "<P>"+
        "However, sometimes the browser just can't replicate server-based filtering - because it uses "+
        "fuzzy logic or matching molecular structures or whatever. In this case, you used to have to "+
        "turn client filtering off, completely. No longer."+
        "<P>"+
        "Setting DataSourceField.filterOn:\"server\" tells SmartGWT that criteria <i>on that specific field</i> "+
        "will always require server filtering.  The SmartGWT filtering system will then continue to use "+
        "client-side filtering for all <i>other</i> fields - providing instantaneous response and reducing server "+
        "load - but for <i>that one field</i>, SmartGWT will ask the server to do the filtering."+
        "<P>"+
        "Note that the 'Description' field, which has <i>filterOn:'serverOnly'</i> set, is also capable of using "+
        "client-side filtering. We're disabling it in this example to demonstrate the interaction pattern with the server. "+
        "<P>"+
        "To test the sample: <ul>"+
        "    <li>First, type \"adding\" in the filter editor of the \"Item\" column to filter the data set to a manageable size.</li>"+
        "    <li>Now type 4 in the \"SKU\" column. You'll see that the label below the grid does not change. This is "+
        "        because the filtering occurred on the client-side.</li>"+
        "    <li>Next, let's filter by \"Description\". This column has filterOn=\"serverOnly\" enabled, so filtering "+
        "        will be performed on the server even though the grid has all its records loaded locally."+
        "        Try typing \"low\". Notice how the area below the grid briefly changes color, "+
        "        indicating that a request to the server has been made. Each time you type something "+ 
        "        in this column, a request is sent to the server.</li>"+
        "</ul>";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            MixedFilteringSample panel = new MixedFilteringSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    private Label serverCountLabel;
    
    private class ServerCountLabel extends Label {
        private int count = 0;  
  
        public ServerCountLabel() {  
            setWidth(700);
            setHeight(40);
            setPadding(10);
            setBorder("1px solid grey");
            setContents("<b>Number of server trips: 0</b>");
        }  
  
        public void updateContent (int totalRows, int startRow, int endRow) {
            count++;
            serverCountLabel.setContents("Number of server trips: " + this.count + 
                                         "<br/>Total rows in this filter set: " + totalRows + 
                                         "<br/>Last range of records returned: " + startRow + " to " + endRow);
        }
    } 
    
    public Canvas getViewPanel() {

        VLayout vLayout = new VLayout();
        vLayout.setWidth100();
        vLayout.setHeight100();
        vLayout.setMembersMargin(10);
    	
        DataSource ds = DataSource.get("filterOnServer", null, new ResponseTransformer() {
            protected void transformResponse(DSResponse response, DSRequest request, Object data) {
                if(request.getOperationType() == DSOperationType.FETCH) {
                    int totalRows = response.getTotalRows(); 
                    int startRow = response.getStartRow(); 
                    int endRow = response.getEndRow(); 
                    ((ServerCountLabel) serverCountLabel).updateContent(totalRows, startRow, endRow); 
                    serverCountLabel.setBackgroundColor("#ffff77"); 
                    new Timer() { 
                        public void run() { 
                            serverCountLabel.setBackgroundColor("#ffffff"); 
                        } 
                    }.schedule(500); 
                }
                defaultTransformResponse(response, request, data);
            }
        });
        
        ListGrid listGrid = new ListGrid();    	
        listGrid.setWidth(700);
        listGrid.setHeight(300);
        listGrid.setShowFilterEditor(true);
        listGrid.setFilterOnKeypress(true);
        listGrid.setAutoFetchData(true);
        listGrid.setDataSource(ds);
        
        serverCountLabel = new ServerCountLabel();
        
        vLayout.setMembers(listGrid, serverCountLabel);

        return vLayout;
    }
    
    public String getIntro() {
        return DESCRIPTION;
    }
    
}