/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.spi.Instantiator;

public abstract class AbstractDynamicMapInstantiator
implements Instantiator {
    public static final String TYPE_KEY = "$type$";
    private final String roleName;

    public AbstractDynamicMapInstantiator(String roleName) {
        if (roleName == null) {
            throw new IllegalArgumentException("`roleName` passed to dynamic-map instantiator cannot be null");
        }
        this.roleName = roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
        if (object instanceof Map) {
            String type = (String)((Map)object).get(TYPE_KEY);
            return this.isSameRole(type);
        }
        return false;
    }

    protected boolean isSameRole(String type) {
        return this.roleName.equals(type);
    }

    @Override
    public boolean isSameClass(Object object, SessionFactoryImplementor sessionFactory) {
        return this.isInstance(object, sessionFactory);
    }

    protected Map generateDataMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TYPE_KEY, this.roleName);
        return map;
    }
}

