/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Service;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class LogEventDataSourceDispatcher
extends Service {
    LinkedBlockingQueue queue;
    String uniqueProcessIdentifier = UUID.randomUUID().toString();
    AtomicLong sequence = new AtomicLong();

    public LogEventDataSourceDispatcher() {
        this.setInterval(0);
        this.setDisableLogging(true);
    }

    public void setQueue(LinkedBlockingQueue queue) {
        this.queue = queue;
    }

    @Override
    public Object execute() throws Exception {
        try {
            Map scEvent = this.convertLogEvent(this.queue.take());
            if (scEvent == null) {
                return null;
            }
            return new DSRequest("ISCLogEvent", "add").setValues(scEvent).execute();
        }
        catch (Exception e) {
            System.out.println("Unable to dispatch log event: " + ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    protected Map convertLogEvent(Object obj) throws Exception {
        Map mdc = null;
        if (obj instanceof Map) {
            mdc = (Map)((Map)obj).get("mdc");
            obj = ((Map)obj).get("event");
        }
        try {
            return Logger.convertEvent(obj, mdc, this.uniqueProcessIdentifier + this.sequence.getAndIncrement());
        }
        catch (Exception ex) {
            throw new Exception("Failed to convert event: " + obj.getClass().getName(), ex);
        }
    }
}

