
package com.smartgwt.client.docs;

/**
 * <h3>Server-side REST Connector</h3>
 * <i><b>NOTE:</b> This article discusses Smart GWT's server-side REST client implementation.
 * It should not be confused with the client-side {@link com.smartgwt.client.data.RestDataSource}
 * implementation;
 *  the client-side dataSource is intended for cases where you are creating the server API and
 *  thus have control over the format and protocols used, but you do not wish to use the 
 *  Smart GWT Server for some reason.  The server-side implementation, which is documented
 *  below, is intended for cases where you need to connect to existing third-party REST APIs 
 *  (which, despite the impression that "REST" is a standardized approach, vary significantly 
 *  from one to the other in their details)</i>
 *  <p> 
 * RestConnector is a built-in server-side {@link com.smartgwt.client.data.DataSource DataSource} 
 *  implementation.  It is able to convert a standard client-submitted or server-created
 * {@link com.smartgwt.client.data.DSRequest DSRequest} into an arbitrary REST webservice call,
 * and convert the 
 * REST service response into a standard {@link com.smartgwt.client.data.DSResponse DSResponse}. 
 * These conversions
 *  are highly configurable, making use of any or all of the following:<ul>
 * <li>{@link com.smartgwt.client.data.DataSource#getRecordXPath Record-level} and {@link
 * com.smartgwt.client.data.DataSourceField#getValueXPath field-level} 
 *  XPath processing</li>
 * <li>{@link com.smartgwt.client.docs.VelocitySupport Velocity-based} templates providing
 * powerful declarative data
 * templating and conversion for both {@link
 * com.smartgwt.client.docs.serverds.DataSource#requestTemplate requests} and 
 * {@link com.smartgwt.client.docs.serverds.DataSource#responseTemplate responses}.  These
 * templates are evaluated at request/response
 *  execution time, so can include dynamic elements such as the criteria sent from the client</li>
 * <li>Where declarative conversion is not sufficient, inline scripts written in Groovy,
 * Javascript
 *  or other JSR-223 languages can add conversion of arbitrary complexity.  Again, we support
 * scripts for converting both {@link
 * com.smartgwt.client.docs.serverds.DataSource#transformRequestScript requests} and 
 * {@link com.smartgwt.client.docs.serverds.DataSource#transformResponseScript responses} at the
 * record-level, and for response
 * data at the {@link com.smartgwt.client.docs.serverds.DataSourceField#fieldValueScript
 * field-level}</li>
 *  </ul>
 *  <h3>Pervasive Velocity support</h3>
 *  <code>RestController</code> was designed to be as flexible and configurable as possible.
 *  One of the ways we achieve this is with pervasive support for Velocity templating.  In the 
 *  descriptor (<code>*.ds.xml</code> file) of a RestController dataSource, you can use Velocity
 *  expressions in any element, and they will be replaced at execution time.  This means that
 *  you can embed references to <code>server.properties</code> items, elements from the values 
 *  and criteria of this operation, elements of other useful context objects, and arbitrary 
 *  values that your code has set up in the Velocity template context (see the 
 * {@link com.smartgwt.client.docs.VelocitySupport Velocity overview} for details of these latter
 * two).  See the
 *  sample config below for examples of how this feature can be used.  Additional examples are
 * also shown in the docs of individual config properties ({@link
 * com.smartgwt.client.docs.serverds.DataSource#headers headers}, 
 *  for example)
 *  <p>
 *  <b>Important:</b> Because we allow references to <code>$criteria</code> and 
 *  <code>$values</code> in <code>RestConnector</code> config, it follows that we re-evaluate
 *  Velocity expressions on every <code>DSRequest</code>; in fact, as the following section
 *  discusses, when there are multiple valueSets, we evaluate Velocity expressions multiple 
 *  times per <code>DSRequest</code>.  However, we do <b>not</b> evaluate <code>$config</code>
 *  references per-<code>DSRequest</code>: <code>$config</code> references are evaluated during
 *  <code>DataSource</code> initialization, and are fixed thereafter.  The main implication of 
 *  this is, if you are pooling and reusing <code>DataSource</code> instances (which is the 
 *  default), <code>$config</code> references will be fixed after initial evaluation for the 
 *  life of the JVM, so you should not expect to be able to change a config setting and have it
 *  picked up in <code>RestConnector</code> Velocity templates.
 *  <h3>Multiple ValueSets</h3>
 *  <code>RestController</code> has a general ability to handle multiple valueSets, but only 
 * for REST services where both the {@link
 * com.smartgwt.client.docs.serverds.DataSource#requestFormat requestFormat} and the
 * {@link com.smartgwt.client.docs.serverds.DataSource#responseFormat responseFormat} are "json". 
 * For example, if we receive a
 *  {@link com.smartgwt.client.data.DSRequest dsRequest} with two valueSets, like this:<pre>
 *     [
 *         {name:"Smith", ID:72},
 *         {name:"Jones", ID:1044}
 *     ]
 *  </pre>
 * We will combine those two records into a single JSON block to send to the remote REST
 * server:<pre>
 *    [{"name":"Smith","ID": 72},{"name":"Jones","ID":1044}]
 *  </pre>
 *  <code>RestConnector</code> is also able to wrap singular records in a list, for remote 
 * services that want to treat all input as a list - see {@link
 * com.smartgwt.client.docs.serverds.DataSource#wrapInList wrapInList}
 *  <p>
 * {@link com.smartgwt.client.docs.serverds.DataSource#requestTemplate Request templates} are also
 * able to handle multiple 
 *  valueSets.  If there are multiple valueSets in the <code>DSRequest</code>, or if 
 *  <code>wrapInList</code> is in force, we will apply each valueSet to the template, 
 *  constructing a list of templated JSON blocks to send to the REST server.
 *  <h3>Authentication</h3>
 *  RestConnector provides the following standard authentication methods:<ul>
 *  <li>Basic Authorization with a username and password or API token</li>
 *  <li>Bearer Authorization with an API token</li>
 * <li>Bearer Authorization with a refresh/access token scheme, such as JSON Web Tokens (JWT)</li>
 *  <li>Manually-constructed Authorization header</li>
 *  <li>Ad-hoc, informal auth schemes, like embedding an API token in the body of the request</li>
 *  </ul>
 *  The supported authentication methods are all secure as long as you are using HTTPS 
 *  connections, but the refresh/access token approach adds an additional layer of security by
 *  using frequently-changed, short-lived tokens instead of credentials that remain valid for 
 *  an extended period.  For this reason, we recommend using that approach if you have the 
 *  choice.  
 *  <p>
 *  As noted, <code>RestConnector</code> is flexible enough that it is able to connect with
 *  REST APIs that use non-standard authentication techniques, such as embedding a token
 *  or username/password credentials in the request body.  These non-standard authentication 
 *  approaches are found more often than might be thought, and although they are non-standard, 
 *  they are not any less secure than the standard approaches as long as you are using HTTPS.
 *  <p>
 * See the {@link com.smartgwt.client.docs.serverds.DataSource#auth auth block} documentation for
 * full details.
 *  <h3>Example configuration</h3>
 * RestConnector configuration is typically expressed in the {@link
 * com.smartgwt.client.docs.serverds.DataSource#serverConfig serverConfig}
 *  block of a DataSource descriptor (<code>.ds.xml</code> file) - the client has no need to 
 *  know about this configuration, and generally should not be able to see it - although 
 * <code>serverConfig</code> is optional in nearly every cases; see the <code>serverConfig</code> 
 *  documentation for details of this.
 *  <p>
 *  An example configuration is shown below.
 *  <pre>
 *    &lt;DataSource
 *        ID="SomeRestDataSource"
 *        serverType="rest"
 *    &gt;
 *      &lt;serverConfig&gt;
 *        &lt;requestFormat&gt;params&lt;/requestFormat&gt;
 *        &lt;responseFormat&gt;json&lt;/responseFormat&gt;
 *        &lt;recordXPath&gt;items&lt;/recordXPath&gt;
 * 
 *        &lt;!-- This is the default URL to send REST requests to, if not overridden at the 
 *                OperationBinding level.  Note, this MUST be declared inside the serverConfig
 *                block, otherwise client code in the browser will try to use it.  This example
 *                just uses plain, untemplated config but there are lots more options - see the
 *                operationBindings below --&gt;
 *        &lt;dataURL&gt;https://somerestservice.com/api/search&lt;/dataURL&gt;
 * 
 *        &lt;auth&gt;
 *          &lt;type&gt;basic&lt;/type&gt;
 *          &lt;username&gt;$config['rest.somerestservice.apiUser']&lt;/username&gt;
 *          &lt;password&gt;$config['rest.somerestservice.apiToken']&lt;/password&gt;
 *        &lt;/auth&gt;
 * 
 *        &lt;operationBindings&gt;
 *          &lt;operationBinding operationType="fetch" operationId="customerFetch"&gt;
 *            &lt;!-- You can use values defined in your server.properties file with the 
 *                    "$config" context variable --&gt;
 *            &lt;dataURL&gt;$config['rest.somerestservice.baseURL']/customers&lt;/dataURL&gt;
 *          &lt;/operationBinding&gt;
 *        
 *          &lt;operationBinding operationType="update" operationId="updateCustomer"&gt;
 *            &lt;!-- And you can use values and criteria sent up from the client with "$values" 
 *                    and "$criteria" --&gt;
 *            &lt;dataURL&gt;$config['rest.somerestservice.baseURL']/customer/$criteria['customerId']?name=$values['custName']&lt;/dataURL&gt;
 *            &lt;requestFormat&gt;json&lt;/requestFormat&gt;
 *          &lt;/operationBinding&gt;
 *        
 *          &lt;operationBinding operationType="remove"&gt;
 *            &lt;!-- And you can use arbitrary values placed in the template context, as with 
 *                    "$deletePath" here --&gt; 
 *            &lt;dataURL&gt;$config['rest.somerestservice.baseURL']/$deletePath/$values['itemKey']&lt;/dataURL&gt;
 *          &lt;/operationBinding&gt;
 *        &lt;/operationBindings&gt;
 *      &lt;/serverConfig&gt;
 *    &lt;/DataSource&gt;
 *  </pre>
 * @see com.smartgwt.client.types.RESTRequestFormat
 * @see com.smartgwt.client.types.RESTResponseFormat
 * @see com.smartgwt.client.types.RESTAuthenticationType
 * @see com.smartgwt.client.data.RESTAuthentication
 * @see com.smartgwt.client.docs.serverds.DataSource#serverConfig
 * @see com.smartgwt.client.docs.serverds.DataSource#headers
 * @see com.smartgwt.client.docs.serverds.OperationBinding#headers
 * @see com.smartgwt.client.docs.serverds.DataSource#params
 * @see com.smartgwt.client.docs.serverds.OperationBinding#params
 * @see com.smartgwt.client.docs.serverds.DataSource#httpMethod
 * @see com.smartgwt.client.docs.serverds.OperationBinding#httpMethod
 * @see com.smartgwt.client.docs.serverds.DataSource#requestFormat
 * @see com.smartgwt.client.docs.serverds.OperationBinding#requestFormat
 * @see com.smartgwt.client.docs.serverds.DataSource#responseFormat
 * @see com.smartgwt.client.docs.serverds.OperationBinding#responseFormat
 * @see com.smartgwt.client.docs.serverds.DataSource#wrapInList
 * @see com.smartgwt.client.docs.serverds.OperationBinding#wrapInList
 * @see com.smartgwt.client.docs.serverds.DataSource#xmlTag
 * @see com.smartgwt.client.docs.serverds.OperationBinding#xmlTag
 * @see com.smartgwt.client.docs.serverds.DataSource#csvDelimiter
 * @see com.smartgwt.client.docs.serverds.OperationBinding#csvDelimiter
 * @see com.smartgwt.client.docs.serverds.DataSource#csvQuoteCharacter
 * @see com.smartgwt.client.docs.serverds.OperationBinding#csvQuoteCharacter
 * @see com.smartgwt.client.docs.serverds.DataSource#suppressAutoMappings
 * @see com.smartgwt.client.docs.serverds.OperationBinding#suppressAutoMappings
 * @see com.smartgwt.client.docs.serverds.DataSource#requestTemplate
 * @see com.smartgwt.client.docs.serverds.OperationBinding#requestTemplate
 * @see com.smartgwt.client.docs.serverds.DataSource#responseTemplate
 * @see com.smartgwt.client.docs.serverds.OperationBinding#responseTemplate
 * @see com.smartgwt.client.docs.serverds.DataSource#requiresCompleteRESTResponse
 * @see com.smartgwt.client.docs.serverds.OperationBinding#requiresCompleteRESTResponse
 * @see com.smartgwt.client.docs.serverds.DataSource#auth
 * @see com.smartgwt.client.docs.serverds.RESTAuthentication#type
 * @see com.smartgwt.client.docs.serverds.RESTAuthentication#username
 * @see com.smartgwt.client.docs.serverds.RESTAuthentication#password
 * @see com.smartgwt.client.docs.serverds.RESTAuthentication#authToken
 * @see com.smartgwt.client.docs.serverds.RESTAuthentication#authHeader
 * @see com.smartgwt.client.docs.serverds.RESTAuthentication#dataSource
 */
public interface ServerRestConnector {
}
