package com.smartgwt.sample.showcase.client.grid.savedSearch;

import com.smartgwt.client.util.Authentication;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.Autofit;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.widgets.form.fields.SavedSearchItem;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.toolbar.ToolStrip;
import com.smartgwt.client.widgets.toolbar.ToolStripButton;
import com.smartgwt.client.widgets.toolbar.ToolStripSeparator;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class GridBuiltinSample extends ShowcasePanel {

    private static final String DESCRIPTION = "<p>If you have Pro Edition or better, every grid you create automatically "+
    "has the ability for users to save & reapply "+
    "stored grid configurations, inclusive of criteria, visible columns & sizes, sort direction and user-created columns.</p>"+
    "<p>"+
    "In the first grid below, saved views are accessed by clicking on the drop-down menu that appears on any column header "+
    "when you hover, and navigating to \"Saved Views\".  This capability is enabled by default for all grids.</p>"+
    "<p>"+
    "In the second grid, the same capability is shown via an external toolbar control labeled \"Grid View\". This provides "+
    "the same capabilities as the built-in menu, but is more obvious to a novice user.</p>"+
    "<p>"+
    "You can try out the pre-configured views for either grid, and then add your own. Try configuring the grid via resizing "+
    "and rearranging columns, adding sort, adding grouping, or even adding custom columns.  Store your view, try switching "+
    "to one of the default views, then back to your stored view: everything is restored as you left it.</p>"+
    "<p>"+
    "By default, saved views are automatically stored via HTML5 browser capabilities, or can alternatively be stored to "+
    "any DataSource, which then enables application administrators to pre-define searches that will appear for end users.</p>";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            GridBuiltinSample panel = new GridBuiltinSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        Authentication.setCurrentUser(new Record() {{ setAttribute("userId", "showcaseSavedSampleViews"); }} );

        DataSource ds = DataSource.get("countryDS");
        // top ListGrid
        final ListGrid builtinViewsMenu = new ListGrid();  
        builtinViewsMenu.setID("builtinViewsMenu");  
        builtinViewsMenu.setWidth100();  
        builtinViewsMenu.setHeight(200);  
        builtinViewsMenu.setAutoFitData(Autofit.HORIZONTAL);  
        builtinViewsMenu.setAutoFitFieldWidths(true);  
        builtinViewsMenu.setLeaveScrollbarGap(true);  
        builtinViewsMenu.setCanGroupBy(true);  
        builtinViewsMenu.setCanFreezeFields(true);  
        builtinViewsMenu.setCanAddFormulaFields(true);  
        builtinViewsMenu.setCanAddFormulaFields(true);  
        builtinViewsMenu.setDataSource(ds);  
        builtinViewsMenu.setAutoFetchData(true);  
        builtinViewsMenu.setShowFilterEditor(true);
        builtinViewsMenu.setAllowFilterOperators(true);
          
        ListGridField countryCodeField1 = new ListGridField("countryCode", "Title");  
        countryCodeField1.setType(ListGridFieldType.IMAGE);  
        countryCodeField1.setWidth(70);  
        countryCodeField1.setImageURLPrefix("flags/16/");  
        countryCodeField1.setImageURLSuffix(".png");  
        countryCodeField1.setCanSort(false);
        ListGridField countryNameField1 = new ListGridField("countryName", "Country", 100);  
        ListGridField capitalField1 = new ListGridField("capital", "Capital", 100);  
        ListGridField populationField1 = new ListGridField("population", "Population", 150);  
        ListGridField areaField1 = new ListGridField("area", "Area (km²)", 200);  
          
        builtinViewsMenu.setFields(countryCodeField1, countryNameField1, capitalField1, populationField1, areaField1);  
          
        ToolStripButton formulaBuilderB1 = new ToolStripButton();  
        formulaBuilderB1.setIcon("icons/16/sc_insertformula.png");  
        formulaBuilderB1.setTitle("Formula Builder");  
        formulaBuilderB1.setAutoFit(true);  
        formulaBuilderB1.setShowDownIcon(false);  
        formulaBuilderB1.addClickHandler(new ClickHandler() {  
            @Override  
            public void onClick(ClickEvent event) {  
                builtinViewsMenu.addFormulaField();  
            }
        });  
          
        ToolStripButton summaryBuilderB1 = new ToolStripButton();  
        summaryBuilderB1.setIcon("icons/16/application_side_tree.png");  
        summaryBuilderB1.setTitle("Summary Builder");  
        summaryBuilderB1.setAutoFit(true);  
        summaryBuilderB1.setShowDownIcon(false);  
        summaryBuilderB1.addClickHandler(new ClickHandler() {  
            @Override  
            public void onClick(ClickEvent event) {  
                builtinViewsMenu.addSummaryField();  
            }  
        });  
          
        ToolStrip preferenceStripB1 = new ToolStrip();  
        preferenceStripB1.setWidth100();  
        preferenceStripB1.addFill();  
        preferenceStripB1.setAlign(Alignment.RIGHT);  
        preferenceStripB1.setMembers(formulaBuilderB1, summaryBuilderB1);  
  
        VLayout topContainer = new VLayout();  
        topContainer.setHeight(240);
        topContainer.setWidth(750);
        topContainer.setLayoutMargin(15);
        topContainer.setMembers(preferenceStripB1, builtinViewsMenu);  
        topContainer.setGroupTitle("Saved Search - Grid Menus");
          
        // bottom ListGrid
        final ListGrid toolbarViewsMenu = new ListGrid();  
        toolbarViewsMenu.setID("toolbarViewsMenu");  
        toolbarViewsMenu.setWidth100();  
        toolbarViewsMenu.setHeight(200);  
        toolbarViewsMenu.setAutoFitData(Autofit.HORIZONTAL);  
        toolbarViewsMenu.setAutoFitFieldWidths(true);  
        toolbarViewsMenu.setLeaveScrollbarGap(true);  
        toolbarViewsMenu.setCanGroupBy(true);  
        toolbarViewsMenu.setCanFreezeFields(true);  
        toolbarViewsMenu.setCanAddFormulaFields(true);  
        toolbarViewsMenu.setCanAddFormulaFields(true);  
        toolbarViewsMenu.setDataSource(ds);  
        toolbarViewsMenu.setAutoFetchData(true);  
        toolbarViewsMenu.setShowFilterEditor(true);
        toolbarViewsMenu.setAllowFilterOperators(true);
        toolbarViewsMenu.setCanSaveSearches(false);
          
        ListGridField countryCodeField2 = new ListGridField("countryCode", "Title");  
        countryCodeField2.setType(ListGridFieldType.IMAGE);  
        countryCodeField2.setWidth(70);  
        countryCodeField2.setImageURLPrefix("flags/16/");  
        countryCodeField2.setImageURLSuffix(".png");  
        countryCodeField2.setCanSort(false);
        ListGridField countryNameField2 = new ListGridField("countryName", "Country", 100);  
        ListGridField capitalField2 = new ListGridField("capital", "Capital", 100);  
        ListGridField populationField2 = new ListGridField("population", "Population", 150);  
        ListGridField areaField2 = new ListGridField("area", "Area (km²)", 200);  
          
        toolbarViewsMenu.setFields(countryCodeField2, countryNameField2, capitalField2, populationField2, areaField2);  
          
        ToolStripButton formulaBuilderB2 = new ToolStripButton();  
        formulaBuilderB2.setIcon("icons/16/sc_insertformula.png");  
        formulaBuilderB2.setTitle("Formula Builder");  
        formulaBuilderB2.setAutoFit(true);  
        formulaBuilderB2.setShowDownIcon(false);  
        formulaBuilderB2.addClickHandler(new ClickHandler() {  
            @Override  
            public void onClick(ClickEvent event) {  
                toolbarViewsMenu.addFormulaField();  
            }
        });  
          
        ToolStripButton summaryBuilderB2 = new ToolStripButton();  
        summaryBuilderB2.setIcon("icons/16/application_side_tree.png");  
        summaryBuilderB2.setTitle("Summary Builder");  
        summaryBuilderB2.setAutoFit(true);  
        summaryBuilderB2.setShowDownIcon(false);  
        summaryBuilderB2.addClickHandler(new ClickHandler() {  
            @Override  
            public void onClick(ClickEvent event) {  
                toolbarViewsMenu.addSummaryField();  
            }  
        });  
          
        DynamicForm gridView = new DynamicForm();
        gridView.setID("gridView");
        gridView.setWidth(300);
        
        SavedSearchItem ssi = new SavedSearchItem();
        ssi.setTitle("Grid View");
        ssi.setShowTitle(true);
        ssi.setWidth(220);
        ssi.setCanAddSearch(true);
        ssi.setTargetComponent(toolbarViewsMenu);
        
        gridView.setFields(ssi);
        
        ToolStrip preferenceStripB2 = new ToolStrip();  
        preferenceStripB2.setWidth100();  
        preferenceStripB2.addFill();  
        preferenceStripB2.setAlign(Alignment.RIGHT);  
        preferenceStripB2.setMembers(gridView, new ToolStripSeparator(), formulaBuilderB2, summaryBuilderB2);  
            
        VLayout bottomContainer = new VLayout();  
        bottomContainer.setHeight(240);
        bottomContainer.setWidth(750);
        bottomContainer.setLayoutMargin(15);
        bottomContainer.setMembers(preferenceStripB2, toolbarViewsMenu);  
        bottomContainer.setGroupTitle("Saved Search - External Toolbar");
        
        VLayout mainContainer = new VLayout();  
        mainContainer.setHeight100();
        mainContainer.setWidth(500);
        mainContainer.setLayoutMargin(15);
        mainContainer.setMembers(topContainer, bottomContainer);
        
        return mainContainer; 
    }

    public String getIntro() {
        return DESCRIPTION;
    }
}