/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.event.shared;

import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.HandlerRegistration;
import com.google.web.bindery.event.shared.UmbrellaException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class SimpleEventBus
extends EventBus {
    private final boolean isReverseOrder;
    private int firingDepth = 0;
    private List<Command> deferredDeltas;
    private final Map<Event.Type<?>, Map<Object, List<?>>> map = new HashMap();

    public SimpleEventBus() {
        this(false);
    }

    @Deprecated
    protected SimpleEventBus(boolean fireInReverseOrder) {
        this.isReverseOrder = fireInReverseOrder;
    }

    @Override
    public <H> HandlerRegistration addHandler(Event.Type<H> type, H handler) {
        return this.doAdd(type, null, handler);
    }

    @Override
    public <H> HandlerRegistration addHandlerToSource(Event.Type<H> type, Object source, H handler) {
        if (source == null) {
            throw new NullPointerException("Cannot add a handler with a null source");
        }
        return this.doAdd(type, source, handler);
    }

    @Override
    public void fireEvent(Event<?> event) {
        this.doFire(event, null);
    }

    @Override
    public void fireEventFromSource(Event<?> event, Object source) {
        if (source == null) {
            throw new NullPointerException("Cannot fire from a null source");
        }
        this.doFire(event, source);
    }

    @Deprecated
    protected <H> void doRemove(Event.Type<H> type, Object source, H handler) {
        if (this.firingDepth > 0) {
            this.enqueueRemove(type, source, handler);
        } else {
            this.doRemoveNow(type, source, handler);
        }
    }

    @Deprecated
    protected <H> H getHandler(Event.Type<H> type, int index) {
        assert (index < this.getHandlerCount(type)) : "handlers for " + type.getClass() + " have size: " + this.getHandlerCount(type) + " so do not have a handler at index: " + index;
        List<H> l = this.getHandlerList(type, null);
        return l.get(index);
    }

    @Deprecated
    protected int getHandlerCount(Event.Type<?> eventKey) {
        return this.getHandlerList(eventKey, null).size();
    }

    @Deprecated
    protected boolean isEventHandled(Event.Type<?> eventKey) {
        return this.map.containsKey(eventKey);
    }

    private void defer(Command command) {
        if (this.deferredDeltas == null) {
            this.deferredDeltas = new ArrayList<Command>();
        }
        this.deferredDeltas.add(command);
    }

    private <H> HandlerRegistration doAdd(final Event.Type<H> type, final Object source, final H handler) {
        if (type == null) {
            throw new NullPointerException("Cannot add a handler with a null type");
        }
        if (handler == null) {
            throw new NullPointerException("Cannot add a null handler");
        }
        if (this.firingDepth > 0) {
            this.enqueueAdd(type, source, handler);
        } else {
            this.doAddNow(type, source, handler);
        }
        return new HandlerRegistration(){
            final /* synthetic */ SimpleEventBus this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void removeHandler() {
                this.this$0.doRemove(type, source, handler);
            }
        };
    }

    private <H> void doAddNow(Event.Type<H> type, Object source, H handler) {
        List<H> l = this.ensureHandlerList(type, source);
        l.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <H> void doFire(Event<H> event, Object source) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        try {
            ListIterator<H> it;
            ++this.firingDepth;
            if (source != null) {
                SimpleEventBus.setSourceOfEvent(event, source);
            }
            List<H> handlers = this.getDispatchList(event.getAssociatedType(), source);
            HashSet<Throwable> causes = null;
            ListIterator<H> listIterator = it = this.isReverseOrder ? handlers.listIterator(handlers.size()) : handlers.listIterator();
            while (this.isReverseOrder ? it.hasPrevious() : it.hasNext()) {
                H handler = this.isReverseOrder ? it.previous() : it.next();
                try {
                    SimpleEventBus.dispatchEvent(event, handler);
                }
                catch (Throwable e) {
                    if (causes == null) {
                        causes = new HashSet<Throwable>();
                    }
                    causes.add(e);
                }
            }
            if (causes != null) {
                throw new UmbrellaException(causes);
            }
        }
        finally {
            --this.firingDepth;
            if (this.firingDepth == 0) {
                this.handleQueuedAddsAndRemoves();
            }
        }
    }

    private <H> void doRemoveNow(Event.Type<H> type, Object source, H handler) {
        List<H> l = this.getHandlerList(type, source);
        boolean removed = l.remove(handler);
        if (removed && l.isEmpty()) {
            this.prune(type, source);
        }
    }

    private <H> void enqueueAdd(final Event.Type<H> type, final Object source, final H handler) {
        this.defer(new Command(){
            final /* synthetic */ SimpleEventBus this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void execute() {
                this.this$0.doAddNow(type, source, handler);
            }
        });
    }

    private <H> void enqueueRemove(final Event.Type<H> type, final Object source, final H handler) {
        this.defer(new Command(){
            final /* synthetic */ SimpleEventBus this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void execute() {
                this.this$0.doRemoveNow(type, source, handler);
            }
        });
    }

    private <H> List<H> ensureHandlerList(Event.Type<H> type, Object source) {
        List<?> handlers;
        Map<Object, List<?>> sourceMap = this.map.get(type);
        if (sourceMap == null) {
            sourceMap = new HashMap();
            this.map.put(type, sourceMap);
        }
        if ((handlers = sourceMap.get(source)) == null) {
            handlers = new ArrayList();
            sourceMap.put(source, handlers);
        }
        return handlers;
    }

    private <H> List<H> getDispatchList(Event.Type<H> type, Object source) {
        List<H> directHandlers = this.getHandlerList(type, source);
        if (source == null) {
            return directHandlers;
        }
        List<H> globalHandlers = this.getHandlerList(type, null);
        ArrayList<H> rtn = new ArrayList<H>(directHandlers);
        rtn.addAll(globalHandlers);
        return rtn;
    }

    private <H> List<H> getHandlerList(Event.Type<H> type, Object source) {
        Map<Object, List<?>> sourceMap = this.map.get(type);
        if (sourceMap == null) {
            return Collections.emptyList();
        }
        List<?> handlers = sourceMap.get(source);
        if (handlers == null) {
            return Collections.emptyList();
        }
        return handlers;
    }

    private void handleQueuedAddsAndRemoves() {
        if (this.deferredDeltas != null) {
            try {
                for (Command c : this.deferredDeltas) {
                    c.execute();
                }
            }
            finally {
                this.deferredDeltas = null;
            }
        }
    }

    private void prune(Event.Type<?> type, Object source) {
        Map<Object, List<?>> sourceMap = this.map.get(type);
        List<?> pruned = sourceMap.remove(source);
        assert (pruned != null) : "Can't prune what wasn't there";
        assert (pruned.isEmpty()) : "Pruned unempty list!";
        if (sourceMap.isEmpty()) {
            this.map.remove(type);
        }
    }

    private static interface Command {
        public void execute();
    }
}

