/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.hibernate.HBProviderInterface;
import com.isomorphic.log.Logger;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.Version;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class HB {
    private static final String CLASS_NAME = HB.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String HB_PREFIX = "hibernate";
    public static final String PROVIDER = "provider";
    public static final String CONFIG_LOOKUP_STYLE = "config.lookupStyle";
    public static final String LOOKUP_STYLE_SPRING = "spring";
    public static final String DEFAULT_HB_PROVIDER = "com.isomorphic.hibernate.HB4Provider";
    public static final String DEFAULT_SPRING_HB_PROVIDER = "com.isomorphic.hibernate.SpringHB4Provider";
    public static final String HB_PROVIDER = "hibernate.provider";
    public static final String TRANSACTION_ATTR = "_isc_hibernate_transaction_";
    public static final String SHORT_TRANSACTION_ATTR = "hibernate";
    private static final HashMap<String, HBProviderInterface> providers = new HashMap();
    private static String BASIC_FORMATTER_IMPL_CLASSNAME = null;

    public static SessionFactory get() {
        return HB.get("");
    }

    public static SessionFactory get(String configName) {
        return HB.getProvider(configName).get();
    }

    public static Session getSession() throws HibernateException {
        return HB.getSession("");
    }

    public static Session getSession(String configName) throws HibernateException {
        return HB.getProvider(configName).getSession();
    }

    public static void returnSession(Session session) {
        HB.returnSession("", session);
    }

    public static void returnSession(String configName, Session session) {
        HB.getProvider(configName).returnSession(session);
    }

    public static Transaction getTransaction(Session session) throws HibernateException {
        return HB.getTransaction("", session);
    }

    public static Transaction getTransaction(String configName, Session session) throws HibernateException {
        return HB.getProvider(configName).getTransaction(session);
    }

    public static void commitTransaction(Transaction tx) throws HibernateException {
        HB.commitTransaction("", tx);
    }

    public static void commitTransaction(String configName, Transaction tx) throws HibernateException {
        HB.getProvider(configName).commitTransaction(tx);
    }

    public static void rollbackTransaction(Transaction tx) {
        HB.rollbackTransaction("", tx);
    }

    public static void rollbackTransaction(String configName, Transaction tx) {
        HB.getProvider(configName).rollbackTransaction(tx);
    }

    public static Dialect getDialect() {
        return HB.getDialect("");
    }

    public static Dialect getDialect(String configName) {
        return HB.getProvider(configName).getDialect();
    }

    public static Iterator<PersistentClass> getMappings() {
        return HB.getMappings("");
    }

    public static Iterator<PersistentClass> getMappings(String configName) {
        return HB.getProvider(configName).getMappings();
    }

    public static PersistentClass getMapping(String entityName) {
        return HB.getMapping("", entityName);
    }

    public static PersistentClass getMapping(String configName, String entityName) {
        return HB.getProvider(configName).getMapping(entityName);
    }

    public static Collection getCollectionMapping(String role) {
        return HB.getCollectionMapping("", role);
    }

    public static Collection getCollectionMapping(String configName, String role) {
        return HB.getProvider(configName).getCollectionMapping(role);
    }

    public static void addMapping(String mapping) {
        HB.addMapping("", mapping);
    }

    public static void addMapping(String configName, String mapping) {
        HB.getProvider(configName).addMapping(mapping);
    }

    public static void addMapping(Class mapping) {
        HB.addMapping("", mapping);
    }

    public static void addMapping(String configName, Class mapping) {
        HB.getProvider(configName).addMapping(mapping);
    }

    public static SchemaUpdate getSchemaUpdate() {
        return HB.getSchemaUpdate("");
    }

    public static SchemaUpdate getSchemaUpdate(String configName) {
        return HB.getProvider(configName).getSchemaUpdate();
    }

    public static SchemaExport getSchemaExport() {
        return HB.getSchemaExport("");
    }

    public static SchemaExport getSchemaExport(String configName) {
        return HB.getProvider(configName).getSchemaExport();
    }

    protected static HBProviderInterface getProvider(String configName) {
        HBProviderInterface hbProvider;
        if (configName == null) {
            configName = "";
        }
        if ((hbProvider = providers.get(configName)) == null) {
            hbProvider = HB.initializeProvider(configName);
        }
        return hbProvider;
    }

    private static synchronized HBProviderInterface initializeProvider(String configName) {
        String hbProviderClassName;
        Config hbConfig = Config.getGlobal().getSubtree("hibernate");
        if (!"".equals(configName)) {
            hbConfig = hbConfig.getSubtree(configName);
        }
        if ((hbProviderClassName = hbConfig.getString((Object)PROVIDER)) == null) {
            String lookupStyle = hbConfig.getString((Object)CONFIG_LOOKUP_STYLE);
            if (lookupStyle != null) {
                if (!LOOKUP_STYLE_SPRING.equals(lookupStyle)) {
                    throw new HibernateException("Lookup style '" + lookupStyle + "' is not supported by Hibernate data source");
                }
                hbProviderClassName = DEFAULT_SPRING_HB_PROVIDER;
            } else {
                hbProviderClassName = DEFAULT_HB_PROVIDER;
            }
            hbConfig.put((Object)PROVIDER, (Object)hbProviderClassName);
        }
        log.info((Object)("Instantiating HB provider: " + hbProviderClassName + " for " + ("".equals(configName) ? "default " : "") + "configuration" + ("".equals(configName) ? "" : " '" + configName + "'")));
        HBProviderInterface hbProvider = HB.instantiateProvider(hbProviderClassName, hbConfig.asProperties());
        providers.put(configName, hbProvider);
        return hbProvider;
    }

    private static synchronized HBProviderInterface instantiateProvider(String clazz, Properties providerProperties) {
        try {
            Class<HBProviderInterface> hbProviderClass = Reflection.classForName((String)clazz).asSubclass(HBProviderInterface.class);
            if (providerProperties == null) {
                return hbProviderClass.newInstance();
            }
            Constructor<HBProviderInterface> hbProviderConstructor = hbProviderClass.getConstructor(Properties.class);
            return hbProviderConstructor.newInstance(providerProperties);
        }
        catch (Exception ex) {
            throw new HibernateException("Unable to initialize HB provider: " + clazz, (Throwable)ex);
        }
    }

    public static String formatSQL(String sql) throws Exception {
        if (BASIC_FORMATTER_IMPL_CLASSNAME == null) {
            BASIC_FORMATTER_IMPL_CLASSNAME = Version.getVersionString().startsWith("3") ? "org.hibernate.jdbc.util.BasicFormatterImpl" : "org.hibernate.engine.jdbc.internal.BasicFormatterImpl";
        }
        Object formatter = Reflection.instantiateClass((String)BASIC_FORMATTER_IMPL_CLASSNAME);
        return (String)Reflection.invokeMethod((Object)formatter, (String)"format", (Object[])new Object[]{sql});
    }
}

