/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.BaseRequestHandler;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.BaseResponse;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.util.DataTools;
import org.apache.commons.lang.StringUtils;

public class DefaultRequestHandler
implements BaseRequestHandler<BaseRequest> {
    public static Logger log = new Logger(DefaultRequestHandler.class);
    private boolean shouldReturnStacktrace;

    public DefaultRequestHandler() {
        this(false);
    }

    public DefaultRequestHandler(boolean shouldReturnStacktrace) {
        this.shouldReturnStacktrace = shouldReturnStacktrace;
    }

    @Override
    public BaseResponse handleRequest(BaseRequest request) {
        BaseResponse baseResponse = null;
        if (request.getDsTransaction() != null && request.getDsTransaction().isSkipRemainingQueue()) {
            log.debug("DSTransaction.skipRemainingQueue has been set, returning response with status of PROCESSING_SKIPPED.");
            if (request instanceof DSRequest) {
                baseResponse = new DSResponse();
            } else if (request instanceof RPCRequest) {
                baseResponse = new RPCResponse();
            }
            if (baseResponse != null) {
                baseResponse.setStatus(4);
            }
        } else {
            try {
                baseResponse = (BaseResponse)request.execute();
            }
            catch (Throwable t1) {
                log.warn((Object)"BaseRequest.execute() failed: ", t1);
                if (request instanceof RPCRequest) {
                    baseResponse = new RPCResponse();
                    baseResponse.setStatus(-1);
                    ((RPCResponse)baseResponse).setData(t1.getLocalizedMessage());
                    if (this.shouldReturnStacktrace) {
                        ((RPCResponse)baseResponse).setStacktrace(DataTools.getStackTrace(t1));
                    }
                }
                if (request instanceof DSRequest) {
                    String errorToString = t1.toString();
                    StackTraceElement[] stack = t1.getStackTrace();
                    Throwable t2 = t1.fillInStackTrace();
                    t1.setStackTrace(stack);
                    if (StringUtils.isNotBlank((String)errorToString) && t2 != null) {
                        log.warn((Object)"dsRequest.execute() failed: ", t1);
                    } else {
                        t1.setStackTrace(stack);
                        log.warn((Object)("dsRequest.execute() failed: " + t1.getClass().getName() + ": " + t1.getMessage() + " (The original exception may be missing information)"), t1);
                    }
                    try {
                        baseResponse = new DSResponse(((DSRequest)request).getDataSource());
                    }
                    catch (Exception e) {
                        log.warn((Object)"Got Exception trying to instantiate error DSResponse - going to try without the DataSource reference", e);
                        baseResponse = new DSResponse();
                    }
                    if (t1 instanceof UpdateWithoutPKException) {
                        baseResponse.setStatus(-9);
                    } else {
                        baseResponse.setStatus(-1);
                    }
                    ((DSResponse)baseResponse).setData(t1.getLocalizedMessage());
                    if (this.shouldReturnStacktrace) {
                        ((DSResponse)baseResponse).setParameter("stacktrace", DataTools.getStackTrace(t1));
                    }
                }
                log.warn("Can't handle request of type '" + request.getClass().getName() + "'");
            }
        }
        if (request.getDsTransaction() != null) {
            request.getDsTransaction().registerResponse(request, baseResponse);
        }
        return baseResponse;
    }

    public void setShouldReturnStacktrace(boolean shouldReturnStacktrace) {
        this.shouldReturnStacktrace = shouldReturnStacktrace;
    }
}

