
package com.smartgwt.client.docs;

/**
 * A common set of context variables and helper functions are available when using templates for 
 * CoTTask.prompt,  CoTProcess.optionalPrompts entries, and  CoTTask.taskPrompt. <p> Context
 * variables: <ul> <li><b>task</b> ? the current  CoTTask instance (ID, title, description,
 * etc)</li> <li><b>process</b> ? the owning  CoTProcess instance (ID, policies, etc)</li>
 * <li><b>goal</b> ? equivalent to process.goal</li> <li><b>state</b> ? the shared {@link
 * com.smartgwt.client.util.workflow.Process#getState CoTProcess.state} object for the
 * workflow</li> <li><b>inputs</b> ? inputs to this task if specified as  task.inputs;     the
 * same data returned by  task.getInputRecord() (may be absent if inputs were not defined)</li>
 * </ul> Helper functions: <ul> <li><b>json(x)</b> ? render a compact JSON representation of x
 * suitable for inclusion in a prompt</li> <li><b>promptPart(nameOrNames, omitNewlines?)</b> /
 * <b>prt(...)</b> ? insert one or more prompt parts     as returned by 
 * CoTProcess.getPromptPart().</li> </ul>
 */
public interface CoTPromptScope {
}
