/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.DoubleLongIndex;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerBlocks
implements TableSpaceManager {
    final DataSpaceManager spaceManager;
    final int scale;
    final int fileBlockSize;
    final int spaceID;
    private DoubleIntIndex spaceList;
    private DoubleIntIndex oldList;
    private DoubleLongIndex oldLargeList;
    private final int capacity;
    private long requestGetCount;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    boolean isModified;
    boolean isInitialised;
    long freshBlockFreePos = 0L;
    long freshBlockLimit = 0L;
    long currentBlockFloor = 0L;
    long currentBlockLimit = 0L;
    int fileBlockIndex = -1;

    public TableSpaceManagerBlocks(DataSpaceManager dataSpaceManager, int n, int n2, int n3, int n4) {
        this.spaceManager = dataSpaceManager;
        this.spaceID = n;
        this.fileBlockSize = n2;
        this.capacity = n3;
        this.scale = n4;
        this.spaceList = new DoubleIntIndex(n3, true);
        this.spaceList.setValuesSearchTarget();
        this.oldList = new DoubleIntIndex(n3, true);
    }

    @Override
    public boolean hasFileRoom(long l) {
        return this.freshBlockLimit - this.freshBlockFreePos > l;
    }

    @Override
    public void addFileBlock(long l, long l2) {
        int n = (int)(this.freshBlockLimit - this.freshBlockFreePos);
        if (n > 0) {
            this.release(this.freshBlockFreePos / (long)this.scale, n);
        }
        this.initialiseFileBlock(null, l, l2);
    }

    @Override
    public void initialiseFileBlock(LongLookup longLookup, long l, long l2) {
        this.isInitialised = true;
        this.freshBlockFreePos = l;
        this.freshBlockLimit = l2;
        this.currentBlockFloor = this.freshBlockFreePos / (long)this.fileBlockSize * (long)(this.fileBlockSize / this.scale);
        this.currentBlockLimit = this.freshBlockLimit / (long)this.scale;
        if (longLookup != null) {
            ((DoubleIntIndex)longLookup).copyTo(this.spaceList);
        }
    }

    private boolean getNewMainBlock(long l) {
        if (!this.isInitialised) {
            this.isInitialised = true;
            this.spaceManager.initialiseTableSpace(this);
            if (this.freshBlockFreePos + l <= this.freshBlockLimit) {
                return true;
            }
        }
        long l2 = ((long)this.fileBlockSize + l) / (long)this.fileBlockSize;
        long l3 = l2 * (long)this.fileBlockSize;
        long l4 = this.spaceManager.getFileBlocks(this.spaceID, (int)l2);
        if (l4 < 0L) {
            return false;
        }
        if (l4 != this.freshBlockLimit) {
            long l5 = this.freshBlockLimit - this.freshBlockFreePos;
            if (l5 > 0L) {
                this.release(this.freshBlockFreePos / (long)this.scale, (int)l5);
            }
            this.freshBlockFreePos = l4;
            this.freshBlockLimit = l4;
        }
        this.freshBlockLimit += l3;
        this.currentBlockFloor = this.freshBlockFreePos / (long)this.fileBlockSize * (long)(this.fileBlockSize / this.scale);
        this.currentBlockLimit = this.freshBlockLimit / (long)this.scale;
        if (this.oldList.size() + this.spaceList.size() > this.oldList.capacity()) {
            this.resetOldList();
        }
        this.oldList.addUnsorted(this.spaceList);
        this.resetOldList();
        this.spaceList.clear();
        return true;
    }

    private long getNewBlock(long l) {
        boolean bl;
        if (this.freshBlockFreePos + l > this.freshBlockLimit && !(bl = this.getNewMainBlock(l))) {
            throw Error.error(468);
        }
        long l2 = this.freshBlockFreePos;
        this.freshBlockFreePos += l;
        return l2 / (long)this.scale;
    }

    @Override
    public int getSpaceID() {
        return this.spaceID;
    }

    @Override
    public synchronized void release(long l, int n) {
        int n2 = n / this.scale;
        this.isModified = true;
        ++this.releaseCount;
        if (l + (long)n2 >= Integer.MAX_VALUE) {
            if (this.oldLargeList == null) {
                this.oldLargeList = new DoubleLongIndex(this.capacity);
            }
            this.oldLargeList.addUnsorted(l, n2);
            if (this.oldLargeList.size() == this.capacity) {
                this.resetOldList();
            }
            return;
        }
        if (l >= this.currentBlockFloor && l < this.currentBlockLimit) {
            this.spaceList.add(l, (long)n2);
            if (this.spaceList.size() == this.capacity) {
                this.resetList(false);
            }
        } else {
            this.oldList.addUnsorted(l, (long)n2);
            if (this.oldList.size() == this.capacity) {
                this.resetOldList();
            }
        }
    }

    @Override
    public synchronized long getFilePosition(int n) {
        ++this.requestGetCount;
        if (this.capacity == 0) {
            return this.getNewBlock(n);
        }
        int n2 = -1;
        int n3 = n / this.scale;
        if (this.spaceList.size() > 0) {
            if (this.spaceList.getValue(0) >= n3) {
                n2 = 0;
            } else {
                n2 = this.spaceList.findFirstGreaterEqualKeyIndex(n3);
                if (n2 == -1) {
                    this.spaceList.compactLookupAsIntervals();
                    this.spaceList.setValuesSearchTarget();
                    n2 = this.spaceList.findFirstGreaterEqualKeyIndex(n3);
                }
            }
        }
        if (n2 == -1) {
            return this.getNewBlock(n);
        }
        ++this.requestCount;
        this.requestSize += (long)n;
        int n4 = this.spaceList.getKey(n2);
        int n5 = this.spaceList.getValue(n2);
        int n6 = n5 - n3;
        this.spaceList.remove(n2);
        if (n6 > 0) {
            int n7 = n4 + n3;
            this.spaceList.add(n7, n6);
        }
        return n4;
    }

    @Override
    public void reset() {
        this.fileBlockIndex = this.freshBlockFreePos == 0L ? -1 : (int)(this.freshBlockFreePos / (long)this.fileBlockSize);
        this.resetOldList();
        this.resetList(true);
        this.freshBlockFreePos = 0L;
        this.freshBlockLimit = 0L;
        this.currentBlockFloor = 0L;
        this.currentBlockLimit = 0L;
    }

    @Override
    public long getLostBlocksSize() {
        long l = this.freshBlockLimit - this.freshBlockFreePos + this.spaceList.getTotalValues() * (long)this.scale + this.oldList.getTotalValues() * (long)this.scale;
        return l;
    }

    @Override
    public boolean isDefaultSpace() {
        return this.spaceID == 7;
    }

    public int getFileBlockIndex() {
        return this.fileBlockIndex;
    }

    private void resetList(boolean bl) {
        this.spaceList.compactLookupAsIntervals();
        if (bl) {
            this.spaceManager.freeTableSpace(this.spaceID, this.spaceList, this.freshBlockFreePos, this.freshBlockLimit);
            this.spaceList.clear();
            this.spaceList.setValuesSearchTarget();
        } else {
            if (this.spaceList.size() > this.capacity - 32) {
                int n = this.capacity / 2;
                for (int i = 0; i < n; ++i) {
                    int n2 = this.spaceList.getKey(i);
                    int n3 = this.spaceList.getValue(i);
                    this.oldList.addUnsorted(n2, n3);
                    if (this.oldList.size() != this.capacity) continue;
                    this.resetOldList();
                }
                this.spaceList.removeRange(0, n);
                this.resetOldList();
            }
            this.spaceList.setValuesSearchTarget();
        }
    }

    private void resetOldList() {
        if (this.oldList.size() > 0) {
            this.oldList.compactLookupAsIntervals();
            this.spaceManager.freeTableSpace(this.spaceID, this.oldList, 0L, 0L);
            this.oldList.clear();
        }
        if (this.oldLargeList != null && this.oldLargeList.size() > 0) {
            this.oldLargeList.compactLookupAsIntervals();
            this.spaceManager.freeTableSpace(this.spaceID, this.oldLargeList, 0L, 0L);
            this.oldLargeList.clear();
        }
    }
}

