/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.AuthenticatorHandledResponse;
import com.isomorphic.base.Config;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceAuthenticator;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.servlet.RequestContext;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.security.Principal;
import java.util.Map;

public class JWTAuthenticator
extends DataSourceAuthenticator {
    public String signatureKey = null;
    public String authorizationPrefix = "Bearer ";
    public String apiKeyField = "apiKey";
    private String userCacheKey = "jwtUser";
    private String userIdCacheKey = "jwtUserId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserId(RequestContext context) throws Exception {
        Object cachedUserId = context.request.getAttribute(this.userIdCacheKey);
        if (cachedUserId != null) {
            return cachedUserId;
        }
        if (this.signatureKey == null) {
            this.log.error("signatureKey is not set in server.properties for this authenticator - unable to decrypt");
            context.response.sendError(500);
            throw new AuthenticatorHandledResponse();
        }
        String authorizationHeader = context.request.getHeader("Authorization");
        if (authorizationHeader == null) {
            context.response.sendError(401);
            this.log.error("Null Authorization header - unable to authenticate request");
            throw new AuthenticatorHandledResponse();
        }
        if (!authorizationHeader.startsWith(this.authorizationPrefix)) {
            context.response.sendError(401);
            this.log.error("Malformed Authorization header - missing required '" + this.authorizationPrefix + "' prefix");
            throw new AuthenticatorHandledResponse();
        }
        String jwt = authorizationHeader.substring(this.authorizationPrefix.length()).trim();
        String apiKey = null;
        try {
            JwtParser jwtParser = Jwts.parser();
            Config requiredClaims = this.localConfig.getSubtree("claims");
            if (requiredClaims != null) {
                for (String requiredClaim : requiredClaims.keySet()) {
                    jwtParser = jwtParser.require(requiredClaim, requiredClaims.get(requiredClaim));
                }
            }
            Jws claims = jwtParser.setSigningKey(this.signatureKey).parseClaimsJws(jwt);
            apiKey = (String)((Claims)claims.getBody()).get((Object)this.apiKeyField);
        }
        catch (Exception e) {
            context.response.sendError(401);
            this.log.error("Unable to verify JWT claims");
            throw new AuthenticatorHandledResponse();
        }
        if (apiKey == null) {
            context.response.sendError(401);
            this.log.error("missing apiKey in claims");
            throw new AuthenticatorHandledResponse();
        }
        DataSource ds = DataSourceManager.getDataSource(this.datasource, null);
        if (ds == null) {
            throw new Exception("Unable to load datasource: " + this.datasource + " for authentication");
        }
        try {
            Map userRow = ds.selectSingle(this.apiKeyField, apiKey);
            if (userRow == null || userRow.size() == 0) {
                context.response.sendError(401);
                this.log.error("submitted apiKey does not match any user records");
                throw new AuthenticatorHandledResponse();
            }
            String username = (String)userRow.get(this.usernameField);
            this.log.debug("JWT auth succeded for username: " + username);
            context.request.setAttribute(this.userIdCacheKey, username);
            String string = username;
            return string;
        }
        finally {
            try {
                DataSourceManager.freeDataSource(ds);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Principal getUser(RequestContext context) throws Exception {
        AuthenticatedUser cachedUser = (AuthenticatedUser)context.request.getAttribute(this.userCacheKey);
        if (cachedUser != null) {
            return cachedUser;
        }
        Object userId = this.getUserId(context);
        AuthenticatedUser user = this.principalForUserId(userId);
        context.request.setAttribute(this.userCacheKey, user);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedUser principalForUserId(Object userId) throws Exception {
        DataSource ds = DataSourceManager.getDataSource(this.datasource, null);
        if (ds == null) {
            throw new Exception("Unable to load datasource: " + this.datasource + " for authentication");
        }
        try {
            Map userRow = ds.selectSingle(this.usernameField, userId);
            if (userRow == null || userRow.size() == 0) {
                throw new Exception("Unable to find user recored for username: " + userId.toString());
            }
            userRow.remove(this.passwordField);
            userRow.remove(this.apiKeyField);
            AuthenticatedUser authenticatedUser = new AuthenticatedUser((String)userRow.get(this.usernameField), userRow, this);
            return authenticatedUser;
        }
        finally {
            try {
                DataSourceManager.freeDataSource(ds);
            }
            catch (Exception exception) {}
        }
    }
}

