var defaultGroup = "AE_Order",
    dsArray = {
        AE_Order: "Orders",
        AE_IssueMaster: "Issues",
        worldDS: "Countries"
    };

var customDataByGroup = {
    "AE_Order": {
        samplePrompts: [
            "Show orders over $30k in the last nine months, starting with the largest order.",
            "Group my orders by Customer alphabetically and show the latest orders first.  Hilite order-totals less than 50k in red. Ignore any orders that are currently in Process."
        ]
    },
    "AE_IssueMaster": {
        samplePrompts: [
            "Show issues with a medium to urgent priority, that took more than 4 days to close.",
            "Group the issues by assignee, showing the oldest open issues first. Ignore closed issues."
        ]
    },
    "worldDS": {
        samplePrompts: [
            "Group by continent, sort by population, hilite GDP less than 20000 in red and GDP more than 100,000 in green, hide the area field, and show only countries that contain a c."
        ]
    }
};

isc.VLayout.create({
    width: "100%",
    members: [
        isc.DynamicForm.create({
            ID: "form",
            width: "100%",
            minWidth: 850,
            maxWidth: 1060,
            cellPadding: 5,
            items: [
                {
                    name: "group",
                    editorType: "SelectItem",
                    endRow: true,
                    required: true,
                    title: "Data Sets",
                    wrapTitle: false,
                    width: 300,
                    valueMap: dsArray,
                    defaultValue: defaultGroup,
                    changed : function (form, groupItem, group) {
                        var samplePromptItem = form.getField("samplePrompt"),
                            promptItem = form.getField("selectedPrompt");
                        samplePromptItem.clearValue();
                        promptItem.clearValue();
                        buttonAI.setPrompt("");

                        var customData = customDataByGroup[group];
                        if (customData) {
                            samplePromptItem.setValueMap(customData.samplePrompts);
                            listGrid.setDataSource(group);                            
                            listGrid.fetchData();
                        }
                    }
                },
                {
                    name: "samplePrompt",
                    editorType: "SelectItem",
                    required: true, wrapTitle: false,
                    title: "Sample Prompts",
                    width: 300,
                    valueMap: customDataByGroup[defaultGroup].samplePrompts,
                    changed : function (form, item, value) {
                        var promptItem = form.getField("selectedPrompt");
                        promptItem.setValue(value);
                        buttonAI.setPrompt(value);
                    }
                },
                {
                    name: "selectedPrompt",
                    editorType: "StaticText",
                    title: "Prompt",
                    width: 500
                }
           ]
        }),
        isc.IButton.create({
            ID: "buttonAI",
            title: "Apply Prompt",
            width: 200,
            click : function () {
                if (form.validate()) {
                    var prompt = form.getField("selectedPrompt").getValue();
                    listGrid.configureViaAI(prompt);
                }
            }
        }),
        isc.ListGrid.create({
            ID: "listGrid",
            width: "100%",
            height: 500,
            autoFetchData: true,
            canConfigureViaAI: true,
            dataSource: defaultGroup,
            showAllColumns: true,
            sortByGroupFirst: true,
            autoFitDateFields: "title"
        })
    ],
    membersMargin: 10
});
