/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class BindingPathOutputCommitter
extends PathOutputCommitter
implements IOStatisticsSource,
StreamCapabilities {
    public static final String NAME = BindingPathOutputCommitter.class.getCanonicalName();
    private final PathOutputCommitter committer;

    public BindingPathOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.committer = PathOutputCommitterFactory.getCommitterFactory(outputPath, context.getConfiguration()).createOutputCommitter(outputPath, context);
    }

    @Override
    public Path getOutputPath() {
        return this.committer.getOutputPath();
    }

    @Override
    public Path getWorkPath() throws IOException {
        return this.committer.getWorkPath();
    }

    @Override
    public void setupJob(JobContext jobContext) throws IOException {
        this.committer.setupJob(jobContext);
    }

    @Override
    public void setupTask(TaskAttemptContext taskContext) throws IOException {
        this.committer.setupTask(taskContext);
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
        return this.committer.needsTaskCommit(taskContext);
    }

    @Override
    public void commitTask(TaskAttemptContext taskContext) throws IOException {
        this.committer.commitTask(taskContext);
    }

    @Override
    public void abortTask(TaskAttemptContext taskContext) throws IOException {
        this.committer.abortTask(taskContext);
    }

    @Override
    public void cleanupJob(JobContext jobContext) throws IOException {
        super.cleanupJob(jobContext);
    }

    @Override
    public void commitJob(JobContext jobContext) throws IOException {
        this.committer.commitJob(jobContext);
    }

    @Override
    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        this.committer.abortJob(jobContext, state);
    }

    @Override
    public boolean isRecoverySupported() {
        return this.committer.isRecoverySupported();
    }

    @Override
    public boolean isCommitJobRepeatable(JobContext jobContext) throws IOException {
        return this.committer.isCommitJobRepeatable(jobContext);
    }

    @Override
    public boolean isRecoverySupported(JobContext jobContext) throws IOException {
        return this.committer.isRecoverySupported(jobContext);
    }

    @Override
    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        this.committer.recoverTask(taskContext);
    }

    @Override
    public boolean hasOutputPath() {
        return this.committer.hasOutputPath();
    }

    @Override
    public String toString() {
        return "BindingPathOutputCommitter{committer=" + this.committer + '}';
    }

    public PathOutputCommitter getCommitter() {
        return this.committer;
    }

    public boolean hasCapability(String capability) {
        if (this.committer instanceof StreamCapabilities) {
            return ((StreamCapabilities)this.committer).hasCapability(capability);
        }
        return false;
    }

    public IOStatistics getIOStatistics() {
        return IOStatisticsSupport.retrieveIOStatistics((Object)this.committer);
    }
}

