import React from 'react';
import { AsyncOperationResult, AsyncOperationResultProps } from './AsyncOperationResult';
import { AsComponentXML } from './core/ReactComponent';


declare interface HiliteViaAIResultProps extends AsyncOperationResultProps {

/**
 * See {@link isc.HiliteViaAIResult.hilites HiliteViaAIResult.hilites}.
 */
hilites?: Hilite[];


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * HiliteViaAIResult wraps the SmartClient object
 * {@link isc.HiliteViaAIResult HiliteViaAIResult} for React, allowing you to import
 * HiliteViaAIResult for use in React JS and JSX.
 * @class
 */
declare class HiliteViaAIResult extends AsyncOperationResult {
    props: AsComponentXML<HiliteViaAIResultProps>;
}
