/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DeclarativeSecurity;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.MultiTenantDSGenerator;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.taglib.VirtualTag;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class LoadDSTag
extends VirtualTag {
    public static final String MULTITENANT_NONE = "none";
    public String ID = null;
    public String serverType = null;
    public String tableName = null;
    public String dbName = null;
    public String locale = null;
    public String location = null;
    public Boolean loadParents = Boolean.FALSE;
    public Boolean mockMode = Boolean.FALSE;
    public String tenantId = null;

    public int doStartTag() throws JspException {
        this.init();
        try {
            if (this.ID == null) {
                throw new JspException("DataSource ID not set in tag - unable to proceed.");
            }
            if (virtualize) {
                return this.virtualizeTag("ds", this.ID);
            }
            LoadDSTag.outputJS(this.ID, this.getLocation(), this.loadParents, this.pageContext, this.locale, this.mockMode, this.tenantId, this.log);
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadDS tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public static void outputJS(String ID, String location, boolean loadParents, PageContext pageContext, String localeName, Logger log) throws Exception {
        LoadDSTag.outputJS(ID, location, loadParents, pageContext, localeName, false, log);
    }

    public static void outputJS(String ID, String location, boolean loadParents, PageContext pageContext, String localeName, boolean mockMode, Logger log) throws Exception {
        LoadDSTag.outputJS(ID, location, loadParents, pageContext, localeName, mockMode, null, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputJS(String ID, String location, boolean loadParents, PageContext pageContext, String localeName, boolean mockMode, String tenantId, Logger log) throws Exception {
        HashMap<String, DataSource> processed = new HashMap<String, DataSource>();
        if (location != null) {
            location = config.getPath("webRoot") + "/" + location;
            String projectDataSources = config.getString("project.datasources");
            projectDataSources = projectDataSources == null ? location : location + ", " + projectDataSources;
            DataTypeMap configOverrides = DataTools.buildMap("project.datasources", projectDataSources);
            config.pushThreadLocal((Map)((Object)configOverrides));
        }
        try {
            String[] multipleIDs = ID.split(",");
            for (int i = 0; i < multipleIDs.length; ++i) {
                LoadDSTag.outputDSAsJS(multipleIDs[i].trim(), loadParents, pageContext, localeName, mockMode, tenantId, log, processed);
            }
        }
        finally {
            if (location != null) {
                config.popThreadLocal();
            }
        }
    }

    public static void outputDSAsJS(String dsName, boolean loadParents, PageContext pageContext, String localeName, Logger log, Map<String, DataSource> processed) throws Exception {
        LoadDSTag.outputDSAsJS(dsName, loadParents, pageContext, localeName, false, null, log, processed);
    }

    public static void outputDSAsJS(String dsName, boolean loadParents, PageContext pageContext, String localeName, boolean mockMode, Logger log, Map<String, DataSource> processed) throws Exception {
        LoadDSTag.outputDSAsJS(dsName, loadParents, pageContext, localeName, mockMode, null, log, processed);
    }

    public static void outputDSAsJS(String dsName, boolean loadParents, PageContext pageContext, String localeName, boolean mockMode, String tenantId, Logger log, Map<String, DataSource> processed) throws Exception {
        String inheritsFrom;
        if (processed.containsKey(dsName)) {
            return;
        }
        DataSource ds = null;
        DSRequest stubRequest = new DSRequest();
        stubRequest.setContext(RequestContext.instance(pageContext));
        if (MULTITENANT_NONE.equals(tenantId)) {
            ds = DataSourceManager.getDataSource(dsName, stubRequest);
        } else {
            if (tenantId != null) {
                stubRequest.setTenantId(tenantId);
            } else {
                tenantId = MultiTenantDSGenerator.getRequestTenantId(stubRequest);
            }
            ds = DataSourceManager.getDataSource(dsName, stubRequest, tenantId);
        }
        stubRequest.setRequestStarted(true);
        stubRequest.freeAllResources();
        if (ds == null) {
            BasicDataSource bds = new BasicDataSource();
            ValidationContext vc = new ValidationContext();
            IType cst = bds.getSimpleType(dsName, vc);
            vc.freeResources();
            if (cst != null) {
                LoadDSTag.printObjectAsJS(pageContext, localeName, log, cst);
                return;
            }
            throw new JspException("Unable to load DataSource for ID: " + dsName);
        }
        if (loadParents && (inheritsFrom = (String)ds.getConfig().get("inheritsFrom")) != null) {
            LoadDSTag.outputDSAsJS(inheritsFrom, loadParents, pageContext, localeName, log, processed);
        }
        ds._cloneConfigForSecurityAnnotations();
        DeclarativeSecurity.annotateDataSourceFields(ds, pageContext.getRequest());
        if (mockMode) {
            ds.getAnnotatedConfig().put("mockMode", true);
        }
        LoadDSTag.printObjectAsJS(pageContext, localeName, log, ds);
        DataSourceManager.free(ds);
        processed.put(dsName, ds);
    }

    private static void printObjectAsJS(PageContext pageContext, String localeName, Logger log, IType cst) throws UnconvertableException, IOException {
        JSTranslater jstran = JSTranslater.get();
        Locale locale = null;
        if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
            log.warn("Locale name " + localeName + " is not valid - ignoring");
        }
        if (locale == null) {
            locale = pageContext.getRequest().getLocale();
        }
        jstran.setLocale(locale);
        jstran.toJS(cst, (Writer)pageContext.getOut());
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getID() {
        return this.ID;
    }

    public void setName(String name) {
        this.ID = name;
    }

    public String getName() {
        return this.ID;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocation(String value) {
        this.location = value;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLoadParents(String loadParents) {
        this.loadParents = Boolean.valueOf(loadParents);
    }

    public String getLoadParents() {
        return this.loadParents.toString();
    }

    public void setMockMode(String mockMode) {
        this.mockMode = Boolean.valueOf(mockMode);
    }

    public String getMockMode() {
        return this.mockMode.toString();
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }
}

