/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.reusableORMDataSource;

import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.util.DataTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ReusableORMDataSource
extends BasicDataSource {
    protected String entityName;
    protected Session currentSession;
    protected static Configuration hibernateConfig;
    protected static SessionFactory sessionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSResponse execute(DSRequest req) throws Exception {
        if (hibernateConfig == null) {
            ReusableORMDataSource.createConfig();
        }
        if (this.entityName == null) {
            this.entityName = this.getProperty("mappedBeanClass");
            if (hibernateConfig.getClassMapping(this.entityName) == null) {
                // empty if block
            }
        }
        this.currentSession = sessionFactory.openSession();
        Transaction tx = this.currentSession.beginTransaction();
        try {
            DSResponse dSResponse = super.execute(req);
            return dSResponse;
        }
        finally {
            tx.commit();
            this.currentSession.close();
        }
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        ArrayList<Disjunction> criterions = new ArrayList<Disjunction>();
        Map rCriteria = req.getCriteria();
        if (rCriteria != null) {
            boolean isFilter = "substring".equals(req.getOperationProperty("textMatchStyle"));
            for (String fieldName : rCriteria.keySet()) {
                Object value = rCriteria.get(fieldName);
                Disjunction criterion = null;
                String fieldType = this.getField(fieldName).getType();
                if (value instanceof List) {
                    criterion = Restrictions.disjunction();
                    Iterator j = ((List)value).iterator();
                    while (j.hasNext()) {
                        criterion.add((Criterion)Restrictions.eq((String)fieldName, j.next()));
                    }
                } else {
                    criterion = isFilter && ("text".equals(fieldType) || "string".equals(fieldType)) ? Restrictions.like((String)fieldName, (String)value.toString(), (MatchMode)MatchMode.ANYWHERE) : Restrictions.eq((String)fieldName, value);
                }
                criterions.add(criterion);
            }
        }
        Criteria criteria = this.currentSession.createCriteria(this.entityName);
        this.addAllCriterions(criteria, criterions);
        long totalRows = -1L;
        if (req.isPaged()) {
            if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
                req.setBatchSize(req.getEndRow() - req.getStartRow());
            }
            criteria.setProjection(Projections.rowCount());
            Object rowCount = criteria.uniqueResult();
            totalRows = 0L;
            if (rowCount instanceof Integer) {
                totalRows = ((Integer)rowCount).intValue();
            } else if (rowCount instanceof Long) {
                totalRows = (Long)rowCount;
            }
            criteria = this.currentSession.createCriteria(this.entityName);
            this.addAllCriterions(criteria, criterions);
            criteria.setMaxResults((int)req.getBatchSize());
            criteria.setFirstResult((int)req.getStartRow());
        }
        List results = null;
        List sortBy = req.getSortByFields();
        for (String sortByField : sortBy) {
            if (sortByField.startsWith("-")) {
                criteria.addOrder(Order.desc((String)sortByField.substring(1)));
                continue;
            }
            criteria.addOrder(Order.asc((String)sortByField));
        }
        results = criteria.list();
        if (totalRows == -1L) {
            totalRows = results.size();
        }
        dsResponse.setTotalRows(totalRows);
        long startRow = 0L;
        long endRow = 0L;
        if (totalRows != 0L) {
            startRow = req.getStartRow();
            endRow = startRow + (long)results.size();
        }
        dsResponse.setStartRow(startRow);
        dsResponse.setEndRow(endRow);
        dsResponse.setData((Object)results);
        return dsResponse;
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        Object record = Reflection.classForName((String)this.entityName).newInstance();
        DataTools.setProperties((Map)req.getValues(), record);
        this.currentSession.saveOrUpdate(this.entityName, record);
        dsResponse.setData(record);
        return dsResponse;
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        String primaryKey = this.getPrimaryKey();
        Serializable id = (Serializable)req.getFieldValue((Object)primaryKey);
        Object record = this.currentSession.get(this.entityName, id);
        this.currentSession.delete(this.entityName, record);
        dsResponse.setData((Object)req.getCriteria());
        return dsResponse;
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        String primaryKey = this.getPrimaryKey();
        Serializable id = (Serializable)req.getFieldValue((Object)primaryKey);
        Object record = null;
        if (id != null) {
            record = this.currentSession.get(this.entityName, id);
        }
        DataTools.setProperties((Map)req.getValues(), record);
        this.currentSession.saveOrUpdate(this.entityName, record);
        dsResponse.setData(record);
        return dsResponse;
    }

    private Criteria addAllCriterions(Criteria criteria, List criterions) {
        Iterator i = criterions.iterator();
        while (i.hasNext()) {
            criteria.add((Criterion)i.next());
        }
        return criteria;
    }

    private static synchronized void createConfig() {
        hibernateConfig = new Configuration();
        sessionFactory = hibernateConfig.configure().buildSessionFactory();
    }
}

