/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.customExport;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class CustomExportErrorResponseDMI {
    private static Logger log = new Logger(DSRequest.class.getName());

    public static DSResponse customExport(RPCManager rpc, HttpServletResponse response) throws Exception {
        try {
            DSRequest request = rpc.getDSRequest();
            Map reqCrit = request.getCriteria();
            if (reqCrit.containsKey("category")) {
                return (DSResponse)new DSResponse(request.getDataSource()).addError("category", "category is not allowed in the criteria").setStatus(-1);
            }
            rpc.doCustomResponse();
            RequestContext.setNoCacheHeaders((HttpServletResponse)response);
            response.setContentType("text/plain");
            String filename = request.getExportFilename();
            response.addHeader("content-disposition", "attachment; filename=" + filename);
            DSRequest req = new DSRequest("supplyItem", "fetch");
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put("category", "General Office Products");
            criteria.put("inStock", true);
            req.setCriteria(criteria);
            List results = req.execute().getDataList();
            StringBuilder content = new StringBuilder("" + results.size() + " 'General Office Products' in stock:\r\n\r\n");
            for (Map record : results) {
                content.append((String)record.get("itemName"));
                content.append("\r\n");
            }
            ServletOutputStream os = response.getOutputStream();
            os.print(content.toString());
            os.flush();
        }
        catch (Exception e) {
            log.warn((Object)e.getStackTrace());
        }
        return null;
    }
}

