/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.Validator;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.Scripting;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.scripting.IScript;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.LocaleMessage;
import com.isomorphic.util.ValidatorException;
import com.isomorphic.velocity.Velocity;
import com.isomorphic.xml.XML;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;

public class DefaultValidators
extends Base {
    private static Logger log = new Logger(DefaultValidators.class.getName());
    private Map validators;
    private static final Map validatorFunctions = Collections.synchronizedMap(new HashMap());
    private static final List clientOnlyValidators = DataTools.makeList("requiredIf");
    static final Map defaultValidators = new HashMap();

    public DefaultValidators(Map theValidators) {
        this.validators = theValidators;
    }

    public static void addValidator(String type, Method method) {
        validatorFunctions.put(type, method);
    }

    public List validateRecords(List records) throws ValidatorException {
        ArrayList<ErrorReport> results = new ArrayList<ErrorReport>();
        Iterator e = records.iterator();
        while (e.hasNext()) {
            ErrorReport errors = this.validateRecord((Map)e.next());
            if (errors == null) continue;
            results.add(errors);
        }
        return results.isEmpty() ? null : results;
    }

    public ErrorReport validateRecord(Map record) throws ValidatorException {
        ErrorReport report = new ErrorReport();
        for (String fieldName : this.validators.keySet()) {
            Object rawFieldValidators = this.validators.get(fieldName);
            if (rawFieldValidators == null) continue;
            List fieldValidators = DataTools.makeListIfSingle(rawFieldValidators);
            DefaultValidators.validateField(record, fieldName, fieldValidators, null, report);
        }
        return report.isEmpty() ? null : report;
    }

    public static ErrorReport validateField(Map record, String fieldName, List fieldValidators) throws ValidatorException {
        return DefaultValidators.validateField(record, fieldName, fieldValidators, null);
    }

    public static ErrorReport validateField(Map record, String fieldName, List fieldValidators, ValidationContext context) throws ValidatorException {
        return DefaultValidators.validateField(record, fieldName, fieldValidators, context, null);
    }

    public static ErrorReport validateField(Map record, String fieldName, List fieldValidators, ValidationContext context, ErrorReport report) throws ValidatorException {
        Object value = record.get(fieldName);
        return DefaultValidators.validateField(record, fieldName, fieldValidators, context, report, value);
    }

    public static ErrorReport validateField(Map recordParam, String fieldName, List fieldValidators, ValidationContext context, ErrorReport report, Object value) throws ValidatorException {
        HashMap<String, Object> record = new HashMap<String, Object>(recordParam);
        boolean contextWasNull = false;
        if (context == null) {
            context = new ValidationContext();
            contextWasNull = true;
        }
        context.clearResultingValue();
        DataSource dataSource = context.getCurrentDataSource();
        context.setResultingValue(value);
        Map storedRecord = context.getStoredRecord();
        Set validatorNullFields = (Set)context.get("addedNullValuesForValidators");
        if (validatorNullFields != null && validatorNullFields.contains(fieldName)) {
            value = storedRecord.get(fieldName);
            record.put(fieldName, value);
            context.setResultingValue(value);
        }
        for (Object fieldValidator : fieldValidators) {
            Object rawCondition;
            String type;
            Validator valParams = null;
            boolean stopIfFalse = false;
            if (fieldValidator instanceof String) {
                type = (String)fieldValidator;
                valParams = new Validator();
            } else {
                Map valParamsMap = (Map)fieldValidator;
                valParams = new Validator(valParamsMap);
                type = valParams.getType();
                stopIfFalse = valParams.isStopIfFalse();
            }
            Object rawValidatorRequiredFields = valParams.get("dependentFields");
            if (rawValidatorRequiredFields != null) {
                List validatorRequiredFields = DataTools.makeListIfSingle(rawValidatorRequiredFields);
                for (String requiredField : validatorRequiredFields) {
                    if (record.containsKey(requiredField) && (validatorNullFields == null || !validatorNullFields.contains(requiredField))) continue;
                    record.put(requiredField, storedRecord.get(requiredField));
                }
            }
            if ((rawCondition = valParams.get("applyWhen")) != null) {
                if (!(rawCondition instanceof Map)) {
                    log.warn("on field: '" + fieldName + "' for validator type '" + type + "', bad 'applyWhen' ignored: " + DataTools.prettyPrint(rawCondition));
                    continue;
                }
                Map condition = (Map)rawCondition;
                if (log.isDebugEnabled()) {
                    log.debug("on field: '" + fieldName + "' for validator type '" + type + "', 'applyWhen' is:\n" + DataTools.prettyPrint(condition) + "\nrecord is:\n" + DataTools.prettyPrint(record));
                }
                boolean result = false;
                HashMap conditionRecord = new HashMap(storedRecord);
                DataTools.mapMerge(record, conditionRecord);
                Set addedNullValues = (Set)context.get("addedNullValues");
                if (addedNullValues != null && addedNullValues.contains(fieldName)) {
                    value = storedRecord.get(fieldName);
                    record.put(fieldName, value);
                    context.setResultingValue(value);
                }
                if (addedNullValues != null) {
                    for (Object name : addedNullValues) {
                        if (!conditionRecord.containsKey(name)) continue;
                        conditionRecord.put(name, storedRecord.get(name));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("NOTE: Record after applying stored values is:\n" + DataTools.prettyPrint(record));
                    log.debug("NOTE: Merged conditionRecord is:\n" + DataTools.prettyPrint(conditionRecord));
                }
                try {
                    result = context.getCurrentDataSource().matchesCriteria(conditionRecord, condition);
                }
                catch (Exception e) {
                    log.warn("on field: '" + fieldName + "' for validate type '" + type + "' evaluation of 'applyWhen' threw exception, ignoring validator.\n" + DataTools.getStackTrace(e));
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info("on field: '" + fieldName + "' conditional validator of type '" + type + "' is: " + (result ? "active" : "inactive"));
                }
                if (!result) continue;
            }
            context.addToTemplateContext("validator", new Validator((Map)valParams));
            context.addToTemplateContext("record", record);
            context.addToTemplateContext("value", value);
            context.addToTemplateContext("dataSource", dataSource);
            context.addToTemplateContext(Velocity.getServletContextMap(context.getRPCManager()));
            ErrorMessage error = DefaultValidators.processValidator(type, value, fieldName, record, valParams, context);
            if (error != null) {
                if (report == null) {
                    report = new ErrorReport();
                }
                report.addError(fieldName, error);
                if (!stopIfFalse) continue;
                break;
            }
            value = context.getResultingValue();
        }
        if (contextWasNull) {
            context.freeResources();
        }
        return report;
    }

    private static ErrorMessage processValidator(String validatorName, Object value, String fieldName, Map record, Validator validator, ValidationContext context) throws ValidatorException {
        if (validator != null && validator.isClientOnly()) {
            return null;
        }
        if (validatorName == null) {
            return new ErrorMessage("Validator missing type property: " + validator + "\nIf this is a custom validator, set the clientOnly property to true.");
        }
        if (clientOnlyValidators.contains(validatorName)) {
            return null;
        }
        validator.addErrorMessageVariable("fieldName", fieldName);
        validator.addErrorMessageVariable("value", value == null ? "null" : value.toString());
        ValidatorFunc vfunc = DefaultValidators.getBuiltinValidator(validatorName);
        if (vfunc != null) {
            ErrorMessage error = vfunc.validate(validator, value, fieldName, record, context);
            if (error != null) {
                try {
                    validator.evaluateErrorMessage(error);
                }
                catch (Exception e) {
                    throw new ValidatorException(e.getMessage());
                }
            }
            return error;
        }
        Method valFunc = (Method)validatorFunctions.get(validatorName);
        if (valFunc == null) {
            String valFuncName = (String)validator.get("serverValidationFunction");
            if (valFuncName == null) {
                return new ErrorMessage("No built-in validator named '" + validatorName + "' was found. Set the clientOnly property to true if this is a custom validator.");
            }
            try {
                valFunc = Reflection.findMethod(valFuncName);
                DefaultValidators.addValidator(validatorName, valFunc);
            }
            catch (Throwable t) {
                log.error((Object)("No implementer for validator: " + validatorName), t);
                return new ErrorMessage("No implementer found for validator named '" + validatorName + "'\nIf you want a validator to be client-side only, set its clientOnly property to true.");
            }
        }
        ErrorMessage error = null;
        try {
            Object[] args = new Object[]{validator, value, record};
            error = (ErrorMessage)valFunc.invoke(null, args);
            if (error != null) {
                validator.evaluateErrorMessage(error);
            }
            return error;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = Reflection.getRealTargetException(t);
            }
            return new ErrorMessage(DataTools.getStackTrace(t));
        }
    }

    public static ValidatorFunc getBuiltinValidator(String validatorName) {
        return (ValidatorFunc)defaultValidators.get(validatorName);
    }

    private static Object getValueAsWholeNumber(Object value, Class clazz, Map validatorParams, ValidationContext context) {
        if (value == null) {
            return null;
        }
        if (Byte.class.equals((Object)clazz) || Byte.TYPE.equals(clazz)) {
            try {
                return new Byte(value.toString());
            }
            catch (NumberFormatException ex) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a whole number in range from -128 to 127.", context));
            }
        }
        if (Short.class.equals((Object)clazz) || Short.TYPE.equals(clazz)) {
            try {
                return new Short(value.toString());
            }
            catch (NumberFormatException ex) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a whole number in range from -32768 to 32767.", context));
            }
        }
        if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
            try {
                return Integer.valueOf(value.toString());
            }
            catch (NumberFormatException ex) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a whole number in range from -2147483648 to 2147483647.", context));
            }
        }
        if (Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
            try {
                return Long.valueOf(value.toString());
            }
            catch (NumberFormatException ex) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a whole number in range from -9223372036854775808 to 9223372036854775807.", context));
            }
        }
        if (BigInteger.class.equals((Object)clazz)) {
            try {
                return new BigInteger(value.toString());
            }
            catch (NumberFormatException ex) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a whole number.", context));
            }
        }
        if (AtomicInteger.class.equals((Object)clazz)) {
            Object num = DefaultValidators.getValueAsWholeNumber(value, Integer.class, validatorParams, context);
            if (num instanceof Integer) {
                return new AtomicInteger((Integer)num);
            }
            return num;
        }
        if (AtomicLong.class.equals((Object)clazz)) {
            Object num = DefaultValidators.getValueAsWholeNumber(value, Long.class, validatorParams, context);
            if (num instanceof Long) {
                return new AtomicLong((Long)num);
            }
            return num;
        }
        return null;
    }

    private static Object getValueAsDecimalNumber(Object value, Class clazz, Map validatorParams, ValidationContext context) {
        if (value == null) {
            return null;
        }
        if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
            try {
                Float f = Float.valueOf(value.toString());
                if (f.isInfinite()) {
                    throw new NumberFormatException("Got infinite number.");
                }
                if (f.isNaN()) {
                    throw new NumberFormatException("Got NaN number.");
                }
                return f;
            }
            catch (NumberFormatException ex) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a valid decimal in range from 1.4E-45 to 3.4028235E38.", context));
            }
        }
        if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
            try {
                Double d = Double.valueOf(value.toString());
                if (d.isInfinite()) {
                    throw new NumberFormatException("Got infinite number.");
                }
                if (d.isNaN()) {
                    throw new NumberFormatException("Got NaN number.");
                }
                return d;
            }
            catch (NumberFormatException ex) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a valid decimal in range from 4.9E-324 to 1.7976931348623157E308.", context));
            }
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            try {
                return new BigDecimal(value.toString());
            }
            catch (NumberFormatException ex) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a valid decimal.", context));
            }
        }
        return null;
    }

    private static Long getParamAsLong(Map params, Object key) {
        Long param = null;
        if (!params.containsKey(key)) {
            return null;
        }
        try {
            String stringParam = params.get(key).toString();
            stringParam = stringParam.trim();
            int decimalIndex = stringParam.indexOf(".");
            if (decimalIndex != -1 && Integer.parseInt(stringParam.substring(decimalIndex + 1)) == 0) {
                stringParam = stringParam.substring(0, decimalIndex);
            }
            param = Long.valueOf(stringParam);
        }
        catch (NumberFormatException e) {
            param = null;
        }
        return param;
    }

    private static Double getParamAsDouble(Map params, Object key) {
        Double value = null;
        if (!params.containsKey(key)) {
            return null;
        }
        try {
            value = Double.valueOf(params.get(key).toString());
        }
        catch (NumberFormatException e) {
            value = null;
        }
        return value;
    }

    private static Date getParamAsDate(Map params, Object key) {
        if (!params.containsKey(key)) {
            return null;
        }
        return DefaultValidators.getValueAsDate(params.get(key));
    }

    private static Date getValueAsDate(Object param) {
        Date date;
        SimpleDateFormat dateFormat;
        if (param == null) {
            return null;
        }
        if (param instanceof Date) {
            return (Date)param;
        }
        String dateString = param.toString();
        if (dateString.length() == 19) {
            dateFormat = dateString.charAt(10) == 'T' ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss Z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            dateString = dateString + " -0000";
        } else {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            log.warn("Parse Exception: \n\n" + e.getStackTrace());
            date = null;
        }
        return date;
    }

    private static String getErrorString(Map params, ValidationContext context) {
        return DefaultValidators.getErrorString(params, "Validation failed", context);
    }

    private static String getErrorString(Map params, String defaultMessage, ValidationContext context) {
        Object errMsgObj = params.get("errorMessage");
        DSRequest dsRequest = context == null ? null : context.getDSRequest();
        return DefaultValidators.getErrorString(errMsgObj, defaultMessage, dsRequest);
    }

    public static String getErrorString(Object errorMsgObj, String defaultMessage, DSRequest dsRequest) {
        String errorMessage;
        if (errorMsgObj instanceof LocaleMessage) {
            Locale locale = dsRequest == null || dsRequest.getContext() == null ? null : dsRequest.getContext().getLocale();
            errorMessage = ((LocaleMessage)errorMsgObj).getMessage(locale);
        } else {
            errorMessage = errorMsgObj == null ? defaultMessage : errorMsgObj.toString();
        }
        return errorMessage;
    }

    static {
        defaultValidators.put("required", new required());
        defaultValidators.put("isBoolean", new isBoolean());
        defaultValidators.put("isInteger", new isInteger());
        defaultValidators.put("isDate", new isDate());
        defaultValidators.put("dateRange", new dateRange());
        defaultValidators.put("isTime", new isTime());
        defaultValidators.put("timeRange", new timeRange());
        defaultValidators.put("integerRange", new integerRange());
        defaultValidators.put("regexp", new regexp());
        defaultValidators.put("regex", new regexp());
        defaultValidators.put("lengthRange", new lengthRange());
        defaultValidators.put("matchesField", new matchesField());
        defaultValidators.put("isOneOf", new isOneOf());
        defaultValidators.put("inSet", new inSet());
        defaultValidators.put("notInSet", new notInSet());
        defaultValidators.put("equals", new equals());
        defaultValidators.put("notEqual", new notEqual());
        defaultValidators.put("contains", new contains());
        defaultValidators.put("doesntContain", new doesntContain());
        defaultValidators.put("substringCount", new substringCount());
        defaultValidators.put("mask", new mask());
        defaultValidators.put("floatLimit", new floatLimit());
        defaultValidators.put("floatPrecision", new floatPrecision());
        defaultValidators.put("floatRange", new floatRange());
        defaultValidators.put("isFloat", new isFloat());
        defaultValidators.put("isIdentifier", new isIdentifier());
        defaultValidators.put("isURL", new isURL());
        defaultValidators.put("isString", new isString());
        defaultValidators.put("inValueMap", new inValueMap());
        defaultValidators.put("isRegexp", new isRegexp());
        defaultValidators.put("integerOrAuto", new integerOrAuto());
        defaultValidators.put("integerOrIdentifier", new integerOrIdentifier());
        defaultValidators.put("isMeasure", new isMeasure());
        defaultValidators.put("serverCustom", new serverCustom());
        defaultValidators.put("isUnique", new isUnique());
        defaultValidators.put("hasRelatedRecord", new hasRelatedRecord());
    }

    static class hasRelatedRecord
    implements ValidatorFunc {
        hasRelatedRecord() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            DSField thisField;
            String fk;
            Map params = context.getTemplateContext();
            String relatedDS = (String)validatorParams.get("relatedDataSource");
            String relatedField = (String)validatorParams.get("relatedField");
            if ((relatedDS == null || relatedField == null) && (fk = (thisField = (DSField)params.get("field")).getForeignKey()) != null) {
                String[] tokens = fk.split("[.]");
                if (tokens.length == 1) {
                    if (relatedDS == null) {
                        relatedDS = ((DataSource)params.get("dataSource")).getName();
                    }
                    if (relatedField == null) {
                        relatedField = tokens[0];
                    }
                } else {
                    if (relatedDS == null) {
                        relatedDS = tokens[0];
                    }
                    if (relatedField == null) {
                        relatedField = tokens[1];
                    }
                }
            }
            if (relatedDS == null || relatedField == null) {
                String error = "Field " + fieldName + " - 'hasRelatedRecord' validation could not derive a relation to test - specify 'relatedDataSource' and 'relatedField' on the validator, or a foreignKey property in this field's DataSource definition.  Cannot proceed, assuming false.";
                log.warn(error);
                return new ErrorMessage(error);
            }
            try {
                DSRequest originalReq;
                DataSource ds = DataSourceManager.get(relatedDS, context.getDSRequest());
                if (ds == null) {
                    String error = "Field " + fieldName + " - 'hasRelatedRecord' validation encountered a 'relatedDataSource' that was not a real DataSource.  Please check your validator code.  Unable to proceed, assuming false.";
                    log.warn(error);
                    return new ErrorMessage(error);
                }
                DSRequest req = new DSRequest(relatedDS, "fetch");
                req.setCriteria(relatedField, value);
                if (validatorParams.get("caseSensitive") != null && Boolean.parseBoolean(validatorParams.get("caseSensitive").toString())) {
                    req.setTextMatchStyle("exactCase");
                }
                if ((originalReq = context.getDSRequest()) != null) {
                    req.setRPCManager(originalReq.getRPCManager());
                }
                if (req.execute().getRowCount() == 0L) {
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Related record does not exist", context));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Field " + fieldName + " - 'hasRelatedRecord' validation encountered unexpected exception."), e);
                return new ErrorMessage(e.getMessage());
            }
            return null;
        }
    }

    static class isUnique
    implements ValidatorFunc {
        isUnique() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null) {
                return null;
            }
            Map params = context.getTemplateContext();
            boolean isAdd = false;
            boolean isUpdate = false;
            DSRequest req = context.getDSRequest();
            if (req != null) {
                isAdd = DataSource.isAdd(req.getOperationType()) || DataSource.isValidate(req.getOperationType()) && req.getPendingAddFlag();
                isUpdate = DataSource.isUpdate(req.getOperationType());
            }
            DataSource ds = (DataSource)params.get("dataSource");
            DSField field = (DSField)params.get("field");
            if (field == null) {
                log.warn("Field " + fieldName + " - 'isUnique' validation encountered a template context where the field was not set.  Unable to  proceed, assuming false");
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Value must be unique", context));
            }
            String realFieldName = field.getName();
            if (ds == null) {
                log.warn("Field " + fieldName + " - 'isUnique' validation encountered a template context where the dataSource was not set.  Unable to  proceed, assuming false");
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Value must be unique", context));
            }
            try {
                DSRequest request = new DSRequest(ds.getName(), "fetch", context.getRPCManager());
                if (validatorParams.get("caseSensitive") != null && Boolean.parseBoolean(validatorParams.get("caseSensitive").toString())) {
                    request.setTextMatchStyle("exactCase");
                }
                if (validatorParams.get("operationId") != null) {
                    request.setOperationId((String)validatorParams.get("operationId"));
                }
                HashMap<String, Object> criteria = new HashMap<String, Object>();
                criteria.put(realFieldName, value);
                String criteriaFieldsString = (String)validatorParams.get("criteriaFields");
                String[] criteriaFields = criteriaFieldsString != null ? criteriaFieldsString.split(",") : new String[]{};
                for (int i = 0; i < criteriaFields.length; ++i) {
                    criteriaFields[i] = criteriaFields[i].trim();
                }
                if (isUpdate) {
                    if (ds.getPrimaryKeys().isEmpty()) {
                        log.warn("unique check cannot be performed for update operation: some criteriaFields are missing and data source has no primary keys - skipping unique check.");
                        return null;
                    }
                    Map existingRecord = null;
                    int recordHasPK = 1;
                    for (String pk : ds.getPrimaryKeys()) {
                        if (record.get(pk) != null) continue;
                        recordHasPK = 0;
                        break;
                    }
                    int existingRecordNeeded = 1;
                    if (recordHasPK != 0 && !DataTools.containsAllKeys(record, criteriaFields)) {
                        existingRecord = ds.fetchById(record, context.getRPCManager());
                    } else if (recordHasPK == 0) {
                        String[] requestCriteria = req.getCriteria();
                        ArrayList<Object> passedKeys = null;
                        if (AdvancedCriteria.isAdvancedCriteria((Map<String, Object>)requestCriteria)) {
                            AdvancedCriteria ac = AdvancedCriteria.fromCollections(requestCriteria);
                            passedKeys = new ArrayList();
                            for (String key : ds.getPrimaryKeys()) {
                                if (ac.getFieldValue(key) == null) continue;
                                passedKeys.add(key);
                            }
                        } else {
                            passedKeys = new ArrayList(requestCriteria.keySet());
                        }
                        List<String> keysPresent = DataTools.setIntersection(ds.getPrimaryKeys(), passedKeys);
                        List keysMissing = DataTools.setDisjunction(ds.getPrimaryKeys(), keysPresent);
                        if (keysMissing != null && !keysMissing.isEmpty()) {
                            log.warn("unique check cannot be performed for update operation: some criteriaFields are missing and primary key is missing in record or criteria - skipping unique check.");
                            return null;
                        }
                        DSRequest _request = new DSRequest(ds.getName(), "fetch", context.getRPCManager());
                        _request.setCriteria(requestCriteria);
                        List existingList = _request.execute().getRecords();
                        if (existingList != null && !existingList.isEmpty()) {
                            if (existingList.size() > 1) {
                                log.warn("unique check cannot be performed for update operation: update criteria filters multiple rows, which is not supported by isUnique validator - skipping unique check.");
                                return null;
                            }
                            existingRecord = (Map)existingList.get(0);
                        }
                    } else {
                        existingRecordNeeded = 0;
                    }
                    if (existingRecord == null && existingRecordNeeded != 0) {
                        log.warn("unique check cannot be performed for update operation: existing record could not be found - skipping unique check.");
                        return null;
                    }
                    if (!DataTools.containsAllKeys(record, criteriaFields)) {
                        for (String criteriaName : criteriaFields) {
                            String key;
                            if (!existingRecord.containsKey(criteriaName)) continue;
                            key = criteriaName;
                            criteria.put(key, existingRecord.get(key));
                        }
                    }
                }
                for (String criteriaName : criteriaFields) {
                    if (!record.containsKey(criteriaName)) continue;
                    String key = criteriaName;
                    criteria.put(key, record.get(key));
                }
                request.setCriteria(criteria);
                if (isUpdate) {
                    OrCriterion orCriterion = new OrCriterion(new Criterion[0]);
                    for (String primaryKey : ds.getPrimaryKeys()) {
                        orCriterion.getCriteria().add(new SimpleCriterion(primaryKey, DefaultOperators.NotEqual, record.get(primaryKey)));
                    }
                    request.addToCriteria(orCriterion);
                }
                if (req != null) {
                    request.setRPCManager(req.getRPCManager());
                }
                HashSet<String> outputs = new HashSet<String>(ds.getPrimaryKeys());
                outputs.add(realFieldName);
                request.setOutputs(new ArrayList<String>(outputs));
                Map<String, Object> oldRecord = request.execute().getRecord();
                if (oldRecord == null) {
                    return null;
                }
                if (isAdd) {
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Value must be unique", context));
                }
                Object newRecordFieldValue = record.get(realFieldName);
                boolean keyMatches = true;
                for (String pkField : ds.getPrimaryKeys()) {
                    Object newRecordPKValue = record.get(pkField);
                    log.debug("unique check: pkField: " + pkField + ", old PK: " + oldRecord.get(pkField) + ", new PK: " + record.get(pkField));
                    if (newRecordPKValue != null && newRecordPKValue.toString().equals(oldRecord.get(pkField).toString())) continue;
                    keyMatches = false;
                    break;
                }
                if (!keyMatches) {
                    log.debug("unique check: key fields do not match, fails unique check");
                } else {
                    log.debug("unique check: unique field: " + realFieldName + ", old unique value: " + oldRecord.get(realFieldName) + ", new unique value: " + record.get(realFieldName));
                    if (newRecordFieldValue != null && newRecordFieldValue.toString().equals(oldRecord.get(realFieldName).toString())) {
                        log.debug("unique check: key fields and unique field match, passes unique check");
                        return null;
                    }
                }
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Value must be unique", context));
            }
            catch (Exception e) {
                log.warn((Object)("Field " + fieldName + " - 'isUnique' validation encountered unexpected exception."), e);
                return new ErrorMessage(e.getMessage());
            }
        }
    }

    static class serverCustom
    implements ValidatorFunc {
        serverCustom() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            Object rawResult;
            Validator validator = validatorParams instanceof Validator ? (Validator)validatorParams : new Validator(validatorParams);
            String expression = validator.getServerCondition();
            if (expression != null) {
                try {
                    String language = validator.getLanguage();
                    if (language == null || "".equals(language.trim())) {
                        language = (String)Config.getProperty("script.validator.defaultLanguage");
                    }
                    if ("velocity".equals(language)) {
                        rawResult = this.evaluateVelocityExpression(validator, value, fieldName, record, context);
                    }
                    rawResult = this.evaluateServerScript(validator, value, fieldName, record, context);
                }
                catch (Exception e) {
                    throw new ValidatorException(e.getMessage());
                }
            } else {
                Map serverObjectConfig = (Map)validator.get("serverObject");
                if (serverObjectConfig == null) {
                    throw new ValidatorException("'serverCustom' validator has neither serverCondition nor serverObject declaration");
                }
                rawResult = this.callServerObject(validator, value, fieldName, record, context);
            }
            Boolean rtnValue = null;
            if (rawResult instanceof Boolean) {
                rtnValue = (Boolean)rawResult;
            } else {
                if (rawResult != null && rawResult.toString().toLowerCase().trim().equals("true")) {
                    rtnValue = Boolean.TRUE;
                }
                if (rawResult != null && rawResult.toString().toLowerCase().trim().equals("false")) {
                    rtnValue = Boolean.FALSE;
                }
            }
            if (rtnValue == null) {
                log.warn("Field " + fieldName + " - 'serverCustom' validation returned null or non boolean value instead of boolean value. Assuming false (validation not passed)");
            }
            if (Boolean.TRUE.equals(rtnValue)) {
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validator, "Failed custom validation", context));
        }

        public Object callServerObject(Validator validator, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            ServerObject serverObject;
            Map serverObjectConfig = (Map)validator.get("serverObject");
            RequestContext requestContext = context.getRequestContext();
            DataSource dataSource = context.getCurrentDataSource();
            String contextString = "'serverCustom' validator for field " + fieldName + " on DataSource " + dataSource.getID();
            ReflectionArgument[] optionalFactoryArgs = new ReflectionArgument[]{new ReflectionArgument(DSRequest.class, (Object)context.getDSRequest(), false, false), new ReflectionArgument(DataSource.class, (Object)dataSource, false, false), new ReflectionArgument(DSField.class, (Object)dataSource.getField(fieldName), false, false)};
            try {
                serverObject = new ServerObject(serverObjectConfig, requestContext, optionalFactoryArgs, contextString);
            }
            catch (Exception e) {
                throw new ValidatorException("Bad serverObject declaration:\n" + DataTools.prettyPrint(serverObjectConfig) + "\n..led to exception:\n" + DataTools.getStackTrace(e));
            }
            ReflectionArgument[] requiredArgs = new ReflectionArgument[]{new ReflectionArgument(Object.class, value, false, false), new ReflectionArgument(Validator.class, (Object)validator, false, false), new ReflectionArgument(String.class, (Object)fieldName, false, false), new ReflectionArgument(Map.class, (Object)record, false, false)};
            ReflectionArgument[] optionalArgs = new ReflectionArgument[]{new ReflectionArgument(DataSource.class, (Object)dataSource, false, false), new ReflectionArgument(DSField.class, (Object)dataSource.getField(fieldName), false, false), new ReflectionArgument(ValidationContext.class, (Object)context, false, false), new ReflectionArgument(RequestContext.class, (Object)requestContext, false, false), new ReflectionArgument(RPCManager.class, (Object)(context != null ? context.getRPCManager() : null), false, false), new ReflectionArgument(DSRequest.class, (Object)(context != null ? context.getDSRequest() : null), false, false), new ReflectionArgument(HttpServletRequest.class, (Object)(requestContext != null ? requestContext.request : null), false, false), new ReflectionArgument(HttpServletResponse.class, (Object)(requestContext != null ? requestContext.response : null), false, false), new ReflectionArgument(ServletContext.class, (Object)(requestContext != null ? requestContext.servletContext : null), false, false), new ReflectionArgument(HttpSession.class, requestContext != null && requestContext.request != null ? requestContext.request.getSession(false) : null, false, false)};
            Object returnValue = null;
            try {
                String methodName = (String)serverObjectConfig.get("methodName");
                if (methodName == null) {
                    methodName = "condition";
                }
                Method method = serverObject.getMethod(methodName);
                Object serverObjectInstance = serverObject.getInstance(method);
                returnValue = Reflection.adaptArgsAndInvoke(serverObjectInstance, method, requiredArgs, optionalArgs);
            }
            catch (Exception e) {
                Throwable t = Reflection.getRealTargetException(e);
                String message = "Validator DMI invocation threw exception: ";
                log.warn(message + DataTools.getStackTrace(t));
                throw new ValidatorException(message + t.getClass().getName() + " with error: " + t.getMessage());
            }
            return returnValue;
        }

        public Object evaluateServerScript(Validator validator, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            String expression = validator.getServerCondition();
            String language = validator.getLanguage();
            Object imports = validator.getScriptImports();
            Map bindings = new HashMap();
            Map bindingsClassName = new HashMap();
            if (context != null) {
                bindings = context.getTemplateContext();
                bindingsClassName = context.getTemplateContextClassNames();
            }
            DataTypeMap<String, Object> params = new DataTypeMap<String, Object>();
            params.put("engineName", language);
            params.put("imports", imports);
            params.put("script", expression);
            params.put("bindings", bindings);
            params.put("bindingsClassName", bindingsClassName);
            Map result = null;
            try {
                IScript script = Scripting.getScript(language);
                result = script.eval(params);
                if (result != null && result instanceof Map) {
                    return result.get("evalResult");
                }
            }
            catch (Exception ex) {
                log.error((Object)"Failed to evaluate script.", ex);
                String message = "Validator script evaluation threw exception: ";
                throw new ValidatorException(message + ex.getClass().getName() + " with error: " + ex.getMessage());
            }
            return null;
        }

        public Object evaluateVelocityExpression(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws Exception {
            String expression = null;
            Object serverCondition = validatorParams.get("serverCondition");
            expression = serverCondition instanceof Map ? (String)((Map)serverCondition).get("#text") : (String)serverCondition;
            Map params = context.getTemplateContext();
            return Velocity.evaluateBooleanExpression(expression, params, "CustomValidator", context.getCurrentDataSource());
        }
    }

    static class isColor
    implements ValidatorFunc {
        isColor() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String str = value.toString();
            int index = 0;
            int length = str.length();
            if (str.charAt(0) == '#') {
                index = 1;
            }
            while (index < length) {
                char ch = str.charAt(index);
                if (!(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F')) {
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Not a valid color", context));
                }
                ++index;
            }
            return null;
        }
    }

    static class isMeasure
    implements ValidatorFunc {
        isMeasure() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("") || value.equals("*")) {
                return null;
            }
            String str = value.toString();
            if (validatorParams.get("errorMessage") == null) {
                validatorParams.put("errorMessage", "Must be a whole number, percentage, \"*\" or \"auto\"");
            }
            if (str.endsWith("%")) {
                try {
                    Long.parseLong(str.substring(0, str.length() - 1));
                }
                catch (NumberFormatException e) {
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Not a valid percentage", context));
                }
                return null;
            }
            return DefaultValidators.getBuiltinValidator("integerOrAuto").validate(validatorParams, value, fieldName, record, context);
        }
    }

    static class integerOrIdentifier
    implements ValidatorFunc {
        integerOrIdentifier() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if (DataTools.isIdentifier((String)value)) {
                return null;
            }
            if (validatorParams.get("errorMessage") == null) {
                validatorParams.put("errorMessage", "Must be a whole number or an identifier");
            }
            return DefaultValidators.getBuiltinValidator("isInteger").validate(validatorParams, value, fieldName, record, context);
        }
    }

    static class integerOrAuto
    implements ValidatorFunc {
        integerOrAuto() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if ("auto".equalsIgnoreCase(value.toString())) {
                return null;
            }
            if (validatorParams.get("errorMessage") == null) {
                validatorParams.put("errorMessage", "Must be a whole number or \"auto\"");
            }
            return DefaultValidators.getBuiltinValidator("isInteger").validate(validatorParams, value, fieldName, record, context);
        }
    }

    static class isRegexp
    implements ValidatorFunc {
        isRegexp() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                Pattern.compile(value.toString());
            }
            catch (PatternSyntaxException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, e.getMessage(), context));
            }
            return null;
        }
    }

    static class inValueMap
    implements ValidatorFunc {
        inValueMap() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            DSField dsField;
            DataSource dataSource;
            if (value == null || value.equals("")) {
                return null;
            }
            Object valueMap = validatorParams.get("valueMap");
            if (valueMap == null && (dataSource = context.getCurrentDataSource()) != null && (dsField = dataSource.getField(fieldName)) != null) {
                valueMap = dsField.getValueMap();
            }
            if (valueMap == null) {
                throw new ValidatorException("inValueMap validator called without a valueMap");
            }
            if (valueMap instanceof Collection) {
                validatorParams.put("list", new ArrayList((Collection)valueMap));
            } else if (valueMap instanceof Map) {
                validatorParams.put("list", DataTools.enumToList(((Map)valueMap).keySet().iterator()));
            } else {
                throw new ValidatorException("The value map must be either a collection or a map");
            }
            return DefaultValidators.getBuiltinValidator("inSet").validate(validatorParams, value, fieldName, record, context);
        }
    }

    static class isString
    implements ValidatorFunc {
        isString() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Element element = context.getCurrentElement();
            if (element != null) {
                try {
                    LocaleMessage lm = XML.toLocaleMessage(element, context);
                    if (lm != null) {
                        context.setResultingValue(lm);
                        return null;
                    }
                    Object obj = XML.toDynamicProperty(element, context);
                    if (obj != null) {
                        context.setResultingValue(obj);
                        return null;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to parse value: " + value), e);
                }
            }
            context.setResultingValue(value.toString());
            return null;
        }
    }

    static class isURL
    implements ValidatorFunc {
        isURL() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                new URL(value.toString());
            }
            catch (MalformedURLException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, e.getMessage(), context));
            }
            return null;
        }
    }

    static class isIdentifier
    implements ValidatorFunc {
        isIdentifier() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if (DataTools.isIdentifier((String)value)) {
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Not a valid identifier", context));
        }
    }

    static class isFloat
    implements ValidatorFunc {
        isFloat() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Object v = DefaultValidators.getValueAsDecimalNumber(value, BigDecimal.class, validatorParams, context);
            if (v instanceof ErrorMessage) {
                return (ErrorMessage)v;
            }
            try {
                Class clazz;
                DataSource ds = context.getCurrentDataSource();
                if (ds == null) {
                    ds = context.getDSRequest().getDataSource();
                }
                if ((v = DefaultValidators.getValueAsDecimalNumber(value, clazz = (clazz = ds.getPropertyJavaClass(fieldName, ds.getField(fieldName), value)) == null ? ds.getFieldJavaType(fieldName) : clazz, validatorParams, context)) instanceof ErrorMessage) {
                    return (ErrorMessage)v;
                }
                if (v == null) {
                    if (clazz != null) {
                        log.warn("Specified class " + clazz.toString() + " does not represent decimal number.");
                    }
                    v = DefaultValidators.getValueAsDecimalNumber(value, Double.class, validatorParams, context);
                }
            }
            catch (Exception ex) {
                v = DefaultValidators.getValueAsDecimalNumber(value, Double.class, validatorParams, context);
            }
            if (v instanceof ErrorMessage) {
                v = DefaultValidators.getValueAsDecimalNumber(value, BigDecimal.class, validatorParams, context);
            }
            context.setResultingValue(v);
            return null;
        }
    }

    static class floatRange
    implements ValidatorFunc {
        floatRange() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if (!((value = DefaultValidators.getValueAsDecimalNumber(value, BigDecimal.class, validatorParams, context)) instanceof Number)) {
                return (ErrorMessage)value;
            }
            Object minObject = DefaultValidators.getValueAsDecimalNumber(validatorParams.get("min"), BigDecimal.class, validatorParams, context);
            Object maxObject = DefaultValidators.getValueAsDecimalNumber(validatorParams.get("max"), BigDecimal.class, validatorParams, context);
            BigDecimal min = minObject == null || !(minObject instanceof BigDecimal) ? null : (BigDecimal)minObject;
            BigDecimal max = maxObject == null || !(maxObject instanceof BigDecimal) ? null : (BigDecimal)maxObject;
            if (min == null && max == null) {
                throw new ValidatorException("integerRange validator called without valid min or max");
            }
            if (max != null && max.compareTo((BigDecimal)value) < 0) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be less than " + max, context), max);
            }
            if (min != null && min.compareTo((BigDecimal)value) > 0) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be greater than " + min, context), min);
            }
            return null;
        }
    }

    static class floatPrecision
    implements ValidatorFunc {
        floatPrecision() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if ((value = DefaultValidators.getValueAsDecimalNumber(value, BigDecimal.class, validatorParams, context)) instanceof ErrorMessage) {
                return (ErrorMessage)value;
            }
            BigDecimal v = ((BigDecimal)value).stripTrailingZeros();
            Object precisionObject = DefaultValidators.getValueAsWholeNumber(validatorParams.get("precision"), Integer.class, validatorParams, context);
            if (precisionObject instanceof ErrorMessage) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Parameter 'precision' must be a whole number.", context));
            }
            Integer precision = (Integer)precisionObject;
            if (precision != null && v.scale() > precision) {
                Object roundToPrecisionObject = validatorParams.get("roundToPrecision");
                if (roundToPrecisionObject != null && Boolean.valueOf(roundToPrecisionObject.toString()).booleanValue()) {
                    v = v.setScale((int)precision, RoundingMode.HALF_UP);
                    try {
                        Class clazz;
                        DataSource ds = context.getCurrentDataSource();
                        if (ds == null) {
                            ds = context.getDSRequest().getDataSource();
                        }
                        clazz = (clazz = ds.getPropertyJavaClass(fieldName, ds.getField(fieldName), value)) == null ? ds.getFieldJavaType(fieldName) : clazz;
                        context.setResultingValue(DataTools.castValue(v, clazz));
                    }
                    catch (Exception ex) {
                        context.setResultingValue(DataTools.castValue(v, Double.class));
                    }
                } else {
                    String message = "No more than " + precision + " digits after the decimal point.";
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, message, context), v.setScale((int)precision, RoundingMode.HALF_UP));
                }
            }
            return null;
        }
    }

    static class floatLimit
    implements ValidatorFunc {
        floatLimit() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            ErrorMessage v = ((ValidatorFunc)defaultValidators.get("floatRange")).validate(validatorParams, value, fieldName, record, context);
            if (v == null) {
                v = ((ValidatorFunc)defaultValidators.get("floatPrecision")).validate(validatorParams, value, fieldName, record, context);
            }
            return v;
        }
    }

    static class mask
    implements ValidatorFunc {
        mask() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String mask2 = (String)validatorParams.get("mask");
            if (mask2 == null) {
                throw new ValidatorException("mask validator called without valid mask");
            }
            if (!Pattern.compile(mask2).matcher(value.toString()).find()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, context));
            }
            return null;
        }
    }

    static class substringCount
    implements ValidatorFunc {
        substringCount() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            String val = value.toString();
            if (substring == null) {
                throw new ValidatorException("substringCount validator called without valid substring");
            }
            long matchCount = 0L;
            for (int i = 0; i < val.length() && (i = val.indexOf(substring, i)) > -1; ++i) {
                ++matchCount;
            }
            String operator = (String)validatorParams.get("operator");
            Long countObj = DefaultValidators.getParamAsLong(validatorParams, "count");
            if (operator == null) {
                operator = "==";
            }
            long count = countObj == null ? 0L : countObj;
            if (operator.equals("==")) {
                if (matchCount == count) {
                    return null;
                }
            } else if (operator.equals("!=")) {
                if (matchCount != count) {
                    return null;
                }
            } else if (operator.equals(">")) {
                if (matchCount > count) {
                    return null;
                }
            } else if (operator.equals("<")) {
                if (matchCount < count) {
                    return null;
                }
            } else if (operator.equals(">=")) {
                if (matchCount >= count) {
                    return null;
                }
            } else if (operator.equals("<=")) {
                if (matchCount <= count) {
                    return null;
                }
            } else {
                throw new ValidatorException("in substringCount validator, operator was " + operator + ", must be one of ==, !=, >, <, >= or <=");
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must contain " + operator + " " + count + " instances of '" + substring + "'", context));
        }
    }

    static class doesntContain
    implements ValidatorFunc {
        doesntContain() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            if (substring == null) {
                throw new ValidatorException("doesntContain validator called without valid substring");
            }
            if (value.toString().indexOf(substring) > -1) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must not contain '" + substring + "'", context));
            }
            return null;
        }
    }

    static class contains
    implements ValidatorFunc {
        contains() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            if (substring == null) {
                throw new ValidatorException("contains validator called without valid substring");
            }
            if (value.toString().indexOf(substring) == -1) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must contain '" + substring + "'", context));
            }
            return null;
        }
    }

    static class notEqual
    implements ValidatorFunc {
        notEqual() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Object targetValue = validatorParams.get("value");
            if (targetValue == null) {
                throw new ValidatorException("notEqual validator called without valid target value");
            }
            if (value.equals(targetValue)) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must not equal '" + targetValue + "'", context));
            }
            return null;
        }
    }

    static class equals
    implements ValidatorFunc {
        equals() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Object targetValue = validatorParams.get("value");
            if (targetValue == null) {
                throw new ValidatorException("equals validator called without valid target value");
            }
            if (!value.equals(targetValue)) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must equal '" + targetValue + "'", context));
            }
            return null;
        }
    }

    static class notInSet
    implements ValidatorFunc {
        notInSet() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Collection list = (Collection)validatorParams.get("list");
            if (list == null) {
                throw new ValidatorException("notInSet validator called without valid list for field: " + fieldName);
            }
            Iterator e = list.iterator();
            while (e.hasNext()) {
                if (!value.toString().equals(e.next().toString())) continue;
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must not be in set " + list.toString() + ".", context));
            }
            return null;
        }
    }

    static class inSet
    implements ValidatorFunc {
        inSet() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Collection list = (Collection)validatorParams.get("list");
            if (list == null) {
                throw new ValidatorException("inSet validator called without valid list for field: " + fieldName);
            }
            Iterator e = list.iterator();
            while (e.hasNext()) {
                if (!value.toString().equals(e.next().toString())) continue;
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be in set " + list.toString() + ".", context));
        }
    }

    static class isOneOf
    implements ValidatorFunc {
        isOneOf() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Collection list = (Collection)validatorParams.get("list");
            if (list == null) {
                throw new ValidatorException("isOneOf validator called without valid list for field: " + fieldName);
            }
            Iterator e = list.iterator();
            while (e.hasNext()) {
                if (!value.toString().equals(e.next().toString())) continue;
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be one of " + list.toString() + ".", context));
        }
    }

    static class matchesField
    implements ValidatorFunc {
        matchesField() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            Object otherField = validatorParams.get("otherField");
            if (otherField == null) {
                throw new ValidatorException("matchesField validator called without valid otherField");
            }
            Object otherFieldValue = record.get(otherField);
            if (value == null && otherFieldValue == null || value.equals(otherFieldValue)) {
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Does not match value in field '" + otherField + "'", context));
        }
    }

    static class lengthRange
    implements ValidatorFunc {
        lengthRange() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("") || value instanceof Boolean) {
                return null;
            }
            Long min = DefaultValidators.getParamAsLong(validatorParams, "min");
            Long max = DefaultValidators.getParamAsLong(validatorParams, "max");
            if (min == null && max == null) {
                throw new ValidatorException("lengthRange validator called without valid min or max");
            }
            String s = value.toString();
            if (max != null && (long)s.length() > max || min != null && (long)s.length() < min) {
                String errorMessage = min == null ? DefaultValidators.getErrorString(validatorParams, "Must be no more than " + max + " characters long", context) : (max == null ? DefaultValidators.getErrorString(validatorParams, "Must be at least " + min + " characters long", context) : DefaultValidators.getErrorString(validatorParams, "Must be between " + min + "-" + max + " characters long", context));
                return new ErrorMessage(errorMessage);
            }
            return null;
        }
    }

    static class regexp
    implements ValidatorFunc {
        regexp() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String expression = (String)validatorParams.get("expression");
            if (expression == null) {
                throw new ValidatorException("regexp validator called without expression");
            }
            if (!Pattern.compile(expression).matcher(value.toString()).find()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, context));
            }
            return null;
        }
    }

    static class integerRange
    implements ValidatorFunc {
        integerRange() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if (!((value = DefaultValidators.getValueAsDecimalNumber(value, BigDecimal.class, validatorParams, context)) instanceof Number)) {
                return (ErrorMessage)value;
            }
            Object minObject = DefaultValidators.getValueAsDecimalNumber(validatorParams.get("min"), BigDecimal.class, validatorParams, context);
            Object maxObject = DefaultValidators.getValueAsDecimalNumber(validatorParams.get("max"), BigDecimal.class, validatorParams, context);
            BigDecimal min = minObject == null || !(minObject instanceof BigDecimal) ? null : (BigDecimal)minObject;
            BigDecimal max = maxObject == null || !(maxObject instanceof BigDecimal) ? null : (BigDecimal)maxObject;
            if (min == null && max == null) {
                throw new ValidatorException("integerRange validator called without valid min or max");
            }
            if (max != null && max.compareTo((BigDecimal)value) < 0) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be less than " + max, context), max);
            }
            if (min != null && min.compareTo((BigDecimal)value) > 0) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be greater than " + min, context), min);
            }
            return null;
        }
    }

    static class timeRange
    implements ValidatorFunc {
        timeRange() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Date val = DefaultValidators.getValueAsDate(value);
            if (val == null) {
                throw new ValidatorException("timeRange validator called without a valid date-value");
            }
            String min = validatorParams.get("min").toString();
            String max = validatorParams.get("max").toString();
            if ((min == null || min.equals("")) && (max == null || max.equals(""))) {
                throw new ValidatorException("timeRange validator called without valid min or max");
            }
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            Date valDate = null;
            Date minTime = null;
            Date maxTime = null;
            try {
                String rawTime = val.getHours() + ":" + val.getMinutes() + ":" + val.getSeconds();
                valDate = timeFormat.parse(rawTime);
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Invalid time value", context));
            }
            try {
                minTime = timeFormat.parse(min);
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "min must be a time-string.", context));
            }
            try {
                maxTime = timeFormat.parse(max);
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "max must be a time-string.", context));
            }
            if (maxTime != null && valDate.getTime() > maxTime.getTime()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be less than " + timeFormat.format(maxTime) + " - time is " + timeFormat.format(valDate), context), (Object)max);
            }
            if (minTime != null && valDate.getTime() < minTime.getTime()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be greater than " + timeFormat.format(minTime) + " - time is " + timeFormat.format(valDate), context), (Object)min);
            }
            return null;
        }
    }

    static class isTime
    implements ValidatorFunc {
        isTime() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value instanceof Date) {
                return null;
            }
            if (value.equals("")) {
                context.setResultingValue(null);
                return null;
            }
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            try {
                Date time = timeFormat.parse(value.toString());
                context.setResultingValue(time);
                return null;
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a time.", context));
            }
        }
    }

    static class dateRange
    implements ValidatorFunc {
        dateRange() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            String max;
            if (value == null || value.equals("")) {
                return null;
            }
            Date val = DefaultValidators.getValueAsDate(value);
            if (val == null) {
                throw new ValidatorException("dateRange validator called without a valid date-value");
            }
            String min = validatorParams.get("min") != null ? validatorParams.get("min").toString() : null;
            String string = max = validatorParams.get("max") != null ? validatorParams.get("max").toString() : null;
            if ((min == null || min.equals("")) && (max == null || max.equals(""))) {
                throw new ValidatorException("dateRange validator called without valid min or max");
            }
            Date minDate = DefaultValidators.getParamAsDate(validatorParams, "min");
            Date maxDate = DefaultValidators.getParamAsDate(validatorParams, "max");
            Boolean inclusive = false;
            Object testVal = validatorParams.get("inclusive");
            if (testVal instanceof Boolean) {
                inclusive = (Boolean)testVal;
            }
            if (maxDate != null && !inclusive.booleanValue() && val.getTime() > maxDate.getTime() || inclusive.booleanValue() && val.getTime() >= maxDate.getTime()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be earlier than " + max, context), (Object)max);
            }
            if (minDate != null && !inclusive.booleanValue() && val.getTime() < minDate.getTime() || inclusive.booleanValue() && val.getTime() <= minDate.getTime()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be later than " + min, context), (Object)min);
            }
            return null;
        }
    }

    static class isDate
    implements ValidatorFunc {
        isDate() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null) {
                return null;
            }
            if (value.equals("")) {
                context.setResultingValue(null);
                return null;
            }
            try {
                Date date;
                Class clazz;
                DataSource ds = context.getCurrentDataSource();
                if (ds == null) {
                    ds = context.getDSRequest().getDataSource();
                }
                if ((clazz = ds.getPropertyJavaClass(fieldName, ds.getField(fieldName), value)) == null && value instanceof Date) {
                    return null;
                }
                if (value instanceof Date) {
                    date = (Date)value;
                } else {
                    SimpleDateFormat dateFormat;
                    String dateString = ((String)value).toString();
                    if (dateString.length() == 19 || dateString.length() == 23) {
                        dateString = dateString + "-0000";
                    }
                    if (dateString.length() == 24 || dateString.length() == 28) {
                        String t = dateString.charAt(10) == 'T' ? "'T'" : " ";
                        String dfString = "yyyy-MM-dd" + t + "HH:mm:ss";
                        if (dateString.length() == 28) {
                            dfString = dfString + ".SSS";
                        }
                        dfString = dfString + "Z";
                        dateFormat = new SimpleDateFormat(dfString);
                    } else {
                        dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    }
                    dateFormat.setLenient(false);
                    date = dateFormat.parse(dateString);
                }
                if (clazz != null) {
                    context.setResultingValue(DataTools.convertType(clazz, date, ds));
                } else {
                    context.setResultingValue(date);
                }
                return null;
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a date.", context));
            }
            catch (Exception e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a date.", context));
            }
        }
    }

    static class isInteger
    implements ValidatorFunc {
        isInteger() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Object v = DefaultValidators.getValueAsWholeNumber(value, BigInteger.class, validatorParams, context);
            if (v instanceof ErrorMessage) {
                return (ErrorMessage)v;
            }
            try {
                Class clazz;
                DataSource ds = context.getCurrentDataSource();
                if (ds == null) {
                    ds = context.getDSRequest().getDataSource();
                }
                if ((v = DefaultValidators.getValueAsWholeNumber(value, clazz = (clazz = ds.getPropertyJavaClass(fieldName, ds.getField(fieldName), value)) == null ? ds.getFieldJavaType(fieldName) : clazz, validatorParams, context)) instanceof ErrorMessage) {
                    return (ErrorMessage)v;
                }
                if (v == null) {
                    v = DefaultValidators.getValueAsDecimalNumber(value, clazz, validatorParams, context);
                    if (v instanceof ErrorMessage) {
                        return (ErrorMessage)v;
                    }
                    if (v == null) {
                        if (clazz != null) {
                            log.warn("Specified class " + clazz.toString() + " does not represent number.");
                        }
                        v = DefaultValidators.getValueAsWholeNumber(value, Long.class, validatorParams, context);
                    }
                }
            }
            catch (Exception ex) {
                v = DefaultValidators.getValueAsWholeNumber(value, Long.class, validatorParams, context);
            }
            if (v instanceof ErrorMessage) {
                v = DefaultValidators.getValueAsWholeNumber(value, BigInteger.class, validatorParams, context);
            }
            context.setResultingValue(v);
            return null;
        }
    }

    static class isBoolean
    implements ValidatorFunc {
        isBoolean() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("") || value instanceof Boolean) {
                return null;
            }
            if (value instanceof Number) {
                double number = ((Number)value).doubleValue();
                context.setResultingValue(number != 0.0);
            } else if (value instanceof String) {
                context.setResultingValue(Boolean.valueOf((String)value));
            } else {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a true/false value", context));
            }
            return null;
        }
    }

    static class required
    implements ValidatorFunc {
        required() {
        }

        @Override
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            block11: {
                if ("".equals(value) || value == null && (!context.isPropertiesOnly() || record.containsKey(fieldName))) {
                    return new ErrorMessage("Field is required");
                }
                DataSource ds = context.getCurrentDataSource();
                if (ds == null) {
                    try {
                        ds = context.getDSRequest().getDataSource();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (ds != null) {
                    DSField field = ds.getField(fieldName);
                    if (field != null) {
                        try {
                            if (!ds.simpleTypeInheritsFrom(field.getType(), "binary")) break block11;
                            Object size = record.get(fieldName + "_filesize");
                            if (size != null && size instanceof Number) {
                                if (((Number)size).longValue() <= 0L) {
                                    return new ErrorMessage("Non-empty file required");
                                }
                                break block11;
                            }
                            log.warn("No size provided for binary field '" + fieldName + "'");
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to determine if field '" + fieldName + "' is binary"), ex);
                        }
                    } else {
                        log.warn("Field '" + fieldName + "' not found in data source '" + ds.getID() + "'");
                    }
                }
            }
            return null;
        }
    }

    public static interface ValidatorFunc {
        public ErrorMessage validate(Map var1, Object var2, String var3, Map var4, ValidationContext var5) throws ValidatorException;
    }
}

